/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.registry;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistry;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.clustering.server.registry.FunctionalRegistryFactoryServiceConfigurator;

public class CacheRegistryFactoryServiceConfigurator<K, V>
extends FunctionalRegistryFactoryServiceConfigurator<K, V>
implements CacheRegistryConfiguration<K, V> {
    private final String containerName;
    private final String cacheName;
    private volatile SupplierDependency<Group<Address>> group;
    private volatile SupplierDependency<Cache<Address, Map.Entry<K, V>>> cache;

    public CacheRegistryFactoryServiceConfigurator(ServiceName name, String containerName, String cacheName) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public Registry<K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
        return new CacheRegistry((CacheRegistryConfiguration)this, entry, closeTask);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName));
        return this;
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return new CompositeDependency(new Dependency[]{this.cache, this.group}).register(builder);
    }

    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }

    public Group<Address> getGroup() {
        return (Group)this.group.get();
    }

    public Cache<Address, Map.Entry<K, V>> getCache() {
        return (Cache)this.cache.get();
    }
}

