/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client.spi;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigException;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigProvider;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client._private.ElytronMessages;
import org.wildfly.security.credential.BearerTokenCredential;

public class RESTEasyClientConfigProviderImpl
implements ClientConfigProvider {
    static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);

    public SSLContext getSSLContext(URI uri) throws ClientConfigException {
        try {
            return AUTH_CONTEXT_CLIENT.getSSLContext(uri, AuthenticationContext.captureCurrent());
        }
        catch (GeneralSecurityException e) {
            throw new ClientConfigException((Throwable)ElytronMessages.log.unableToObtainSslContext());
        }
    }

    public String getUsername(URI uri) throws ClientConfigException {
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent()));
        NameCallback nameCallback = new NameCallback("user name");
        try {
            callbackHandler.handle(new Callback[]{nameCallback});
            return nameCallback.getName();
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new ClientConfigException((Throwable)ElytronMessages.log.nameCallbackHandlingWasUnsuccessful());
        }
    }

    public String getPassword(URI uri) throws ClientConfigException {
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent()));
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            callbackHandler.handle(new Callback[]{passwordCallback});
            char[] password = passwordCallback.getPassword();
            if (password == null) {
                return null;
            }
            return new String(password);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new ClientConfigException((Throwable)ElytronMessages.log.passwordCallbackHandlingWasUnsuccessful());
        }
    }

    public String getBearerToken(URI uri) throws ClientConfigException {
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent()));
        CredentialCallback credentialCallback = new CredentialCallback(BearerTokenCredential.class);
        try {
            callbackHandler.handle(new Callback[]{credentialCallback});
            BearerTokenCredential token = (BearerTokenCredential)credentialCallback.getCredential(BearerTokenCredential.class);
            if (token == null) {
                return null;
            }
            return token.getToken();
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new ClientConfigException((Throwable)ElytronMessages.log.passwordCallbackHandlingWasUnsuccessful());
        }
    }
}

