/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;

public class JMSConsumerToMessageConsumer
implements MessageConsumer {
    private final JMSConsumer jmsConsumer;

    public JMSConsumerToMessageConsumer(JMSConsumer jmsConsumer) {
        this.jmsConsumer = jmsConsumer;
    }

    public String getMessageSelector() throws JMSException {
        try {
            return this.jmsConsumer.getMessageSelector();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        try {
            return this.jmsConsumer.getMessageListener();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        try {
            this.jmsConsumer.setMessageListener(listener);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Message receive() throws JMSException {
        try {
            return this.jmsConsumer.receive();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Message receive(long timeout) throws JMSException {
        try {
            return this.jmsConsumer.receive(timeout);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Message receiveNoWait() throws JMSException {
        try {
            return this.jmsConsumer.receiveNoWait();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void close() throws JMSException {
        try {
            this.jmsConsumer.close();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }
}

