/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public final class HandlerChainService
implements Service {
    private final String handlerChainId;
    private final String protocolBindings;
    private final List<Supplier<UnifiedHandlerMetaData>> handlerSuppliers;
    private final Consumer<UnifiedHandlerChainMetaData> handlerChainConsumer;

    public HandlerChainService(String handlerChainType, String handlerChainId, String protocolBindings, Consumer<UnifiedHandlerChainMetaData> handlerChainConsumer, List<Supplier<UnifiedHandlerMetaData>> handlerSuppliers) {
        if (!handlerChainType.equalsIgnoreCase("pre-handler-chain") && !handlerChainType.equals("post-handler-chain")) {
            throw new RuntimeException((Throwable)WSLogger.ROOT_LOGGER.wrongHandlerChainType(handlerChainType, "pre-handler-chain", "post-handler-chain"));
        }
        this.handlerChainId = handlerChainId;
        this.protocolBindings = protocolBindings;
        this.handlerChainConsumer = handlerChainConsumer;
        this.handlerSuppliers = handlerSuppliers;
    }

    public void start(StartContext context) {
        ArrayList<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
        for (Supplier<UnifiedHandlerMetaData> handlerSupplier : this.handlerSuppliers) {
            handlers.add(handlerSupplier.get());
        }
        Collections.sort(handlers, HandlersComparator.INSTANCE);
        this.handlerChainConsumer.accept(new UnifiedHandlerChainMetaData(null, null, this.protocolBindings, handlers, false, this.handlerChainId));
    }

    public void stop(StopContext context) {
        this.handlerChainConsumer.accept(null);
    }

    private static final class HandlersComparator
    implements Comparator<UnifiedHandlerMetaData> {
        private static final Comparator<UnifiedHandlerMetaData> INSTANCE = new HandlersComparator();

        private HandlersComparator() {
        }

        @Override
        public int compare(UnifiedHandlerMetaData o1, UnifiedHandlerMetaData o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

