/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

public class LastValueQueue
extends QueueImpl {
    private static final Logger logger = Logger.getLogger(LastValueQueue.class);
    private final Map<SimpleString, HolderReference> map = new ConcurrentHashMap<SimpleString, HolderReference>();
    private final SimpleString lastValueKey;
    protected final LinkedList<MessageReference> nextDeliveries = new LinkedList();

    @Override
    protected MessageReference nextDelivery() {
        return this.nextDeliveries.poll();
    }

    @Override
    protected void repeatNextDelivery(MessageReference reference) {
        this.nextDeliveries.addFirst(reference);
    }

    @Deprecated
    public LastValueQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, SimpleString lastValueKey, Boolean nonDestructive, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(new QueueConfiguration(name).setId(Long.valueOf(persistenceID)).setAddress(address).setFilterString(filter.getFilterString()).setUser(user).setDurable(Boolean.valueOf(durable)).setTemporary(Boolean.valueOf(temporary)).setAutoCreated(Boolean.valueOf(autoCreated)).setRoutingType(routingType).setMaxConsumers(maxConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setPurgeOnNoConsumers(purgeOnNoConsumers).setAutoDelete(autoDelete).setAutoDeleteDelay(autoDeleteDelay).setAutoDeleteMessageCount(autoDeleteMessageCount).setConfigurationManaged(Boolean.valueOf(configurationManaged)).setLastValueKey(lastValueKey), pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    public LastValueQueue(QueueConfiguration queueConfiguration, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super(queueConfiguration, pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
        this.lastValueKey = queueConfiguration.getLastValueKey();
    }

    @Override
    public synchronized void addTail(MessageReference ref, boolean direct) {
        if (this.scheduleIfPossible(ref)) {
            return;
        }
        SimpleString prop = ref.getLastValueProperty();
        if (prop != null) {
            HolderReference hr = this.map.get(prop);
            if (hr != null) {
                if (this.isNonDestructive() && hr.isInDelivery()) {
                    hr.setReplacementRef(ref);
                } else {
                    this.replaceLVQMessage(ref, hr);
                    if (this.isNonDestructive() && hr.isDelivered()) {
                        hr.resetDelivered();
                        this.nextDeliveries.add(hr);
                        this.deliverAsync();
                    }
                }
            } else {
                hr = new HolderReference(prop, ref);
                this.map.put(prop, hr);
                super.addTail(hr, this.isNonDestructive() ? false : direct);
            }
        } else {
            super.addTail(ref, this.isNonDestructive() ? false : direct);
        }
    }

    @Override
    public long getMessageCount() {
        if (this.pageSubscription != null) {
            return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + this.pageSubscription.getMessageCount();
        }
        return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount();
    }

    @Override
    public void addSorted(MessageReference ref, boolean scheduling) {
        this.addHead(ref, scheduling);
    }

    @Override
    public void addSorted(List<MessageReference> refs, boolean scheduling) {
        this.addHead(refs, scheduling);
    }

    @Override
    public synchronized void addHead(MessageReference ref, boolean scheduling) {
        if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
            return;
        }
        SimpleString lastValueProp = ref.getLastValueProperty();
        if (lastValueProp != null) {
            HolderReference hr = this.map.get(lastValueProp);
            if (hr != null) {
                if (scheduling) {
                    this.replaceLVQMessage(ref, hr);
                } else {
                    super.referenceHandled(ref);
                    try {
                        super.acknowledge(ref);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                    }
                }
            } else {
                hr = new HolderReference(lastValueProp, ref);
                this.map.put(lastValueProp, hr);
                super.addHead(hr, scheduling);
            }
        } else {
            super.addHead(ref, scheduling);
        }
    }

    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        HolderReference hr;
        if (this.isNonDestructive() && ref instanceof HolderReference && (hr = (HolderReference)ref).getReplacementRef() != null) {
            this.replaceLVQMessage(hr.getReplacementRef(), hr);
        }
        super.postAcknowledge(ref, reason);
    }

    @Override
    public boolean allowsReferenceCallback() {
        return false;
    }

    @Override
    public QueueConfiguration getQueueConfiguration() {
        return super.getQueueConfiguration().setLastValue(Boolean.valueOf(true));
    }

    private void replaceLVQMessage(MessageReference ref, HolderReference hr) {
        MessageReference oldRef = hr.getReference();
        this.referenceHandled(oldRef);
        super.refRemoved(oldRef);
        try {
            oldRef.acknowledge(null, AckReason.REPLACED, null);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
        }
        hr.setReference(ref);
        this.addRefSize(ref);
        this.refAdded(ref);
    }

    @Override
    protected void refRemoved(MessageReference ref) {
        this.removeIfCurrent(ref);
        super.refRemoved(ref);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (reason == AckReason.EXPIRED || reason == AckReason.KILLED) {
            this.removeIfCurrent(ref);
        }
        super.acknowledge(ref, reason, consumer);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (reason == AckReason.EXPIRED || reason == AckReason.KILLED) {
            this.removeIfCurrent(ref);
        }
        super.acknowledge(tx, ref, reason, consumer);
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        SimpleString lastValueProp = ref.getLastValueProperty();
        if (lastValueProp != null) {
            HolderReference hr = new HolderReference(lastValueProp, ref);
            this.map.put(lastValueProp, hr);
            super.reload(hr);
        } else {
            super.reload(ref);
        }
    }

    private synchronized void removeIfCurrent(MessageReference ref) {
        MessageReference current;
        SimpleString lastValueProp = ref.getLastValueProperty();
        if (lastValueProp != null && (current = (MessageReference)this.map.get(lastValueProp)) == ref) {
            this.map.remove(lastValueProp);
        }
    }

    @Override
    QueueImpl.QueueIterateAction createDeleteMatchingAction(AckReason ackReason) {
        final QueueImpl.QueueIterateAction queueIterateAction = super.createDeleteMatchingAction(ackReason);
        return new QueueImpl.QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                LastValueQueue.this.removeIfCurrent(ref);
                return queueIterateAction.actMessage(tx, ref);
            }
        };
    }

    @Override
    public boolean isLastValue() {
        return true;
    }

    @Override
    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    public synchronized Set<SimpleString> getLastValueKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LastValueQueue)) {
            return false;
        }
        LastValueQueue other = (LastValueQueue)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    private static class HolderReference
    implements MessageReference {
        private final SimpleString prop;
        private volatile boolean delivered = false;
        private volatile MessageReference ref;
        private volatile MessageReference replacementRef;
        private long consumerID;
        private boolean hasConsumerID = false;

        public MessageReference getReplacementRef() {
            return this.replacementRef;
        }

        public void setReplacementRef(MessageReference replacementRef) {
            this.replacementRef = replacementRef;
        }

        public void resetDelivered() {
            this.delivered = false;
        }

        public boolean isDelivered() {
            return this.delivered;
        }

        HolderReference(SimpleString prop, MessageReference ref) {
            this.prop = prop;
            this.ref = ref;
        }

        @Override
        public void onDelivery(Consumer<? super MessageReference> callback) {
        }

        MessageReference getReference() {
            return this.ref;
        }

        @Override
        public void handled() {
            this.delivered = true;
            this.ref.handled();
            if (!this.ref.getQueue().isNonDestructive()) {
                ((LastValueQueue)this.ref.getQueue()).removeIfCurrent(this);
            }
        }

        @Override
        public void setInDelivery(boolean inDelivery) {
            this.ref.setInDelivery(inDelivery);
        }

        @Override
        public boolean isInDelivery() {
            return this.ref.isInDelivery();
        }

        @Override
        public Object getProtocolData() {
            return this.ref.getProtocolData();
        }

        @Override
        public void setProtocolData(Object data) {
            this.ref.setProtocolData(data);
        }

        @Override
        public void setAlreadyAcked() {
            this.ref.setAlreadyAcked();
        }

        @Override
        public boolean isAlreadyAcked() {
            return this.ref.isAlreadyAcked();
        }

        void setReference(MessageReference ref) {
            this.ref = ref;
        }

        @Override
        public MessageReference copy(Queue queue) {
            return this.ref.copy(queue);
        }

        @Override
        public void decrementDeliveryCount() {
            this.ref.decrementDeliveryCount();
        }

        @Override
        public int getDeliveryCount() {
            return this.ref.getDeliveryCount();
        }

        @Override
        public Message getMessage() {
            return this.ref.getMessage();
        }

        @Override
        public long getMessageID() {
            return this.ref.getMessageID();
        }

        @Override
        public boolean isDurable() {
            return this.getMessage().isDurable();
        }

        @Override
        public SimpleString getLastValueProperty() {
            return this.prop;
        }

        @Override
        public Queue getQueue() {
            return this.ref.getQueue();
        }

        @Override
        public long getScheduledDeliveryTime() {
            return this.ref.getScheduledDeliveryTime();
        }

        @Override
        public void incrementDeliveryCount() {
            this.ref.incrementDeliveryCount();
        }

        @Override
        public void setDeliveryCount(int deliveryCount) {
            this.ref.setDeliveryCount(deliveryCount);
        }

        @Override
        public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
            this.ref.setScheduledDeliveryTime(scheduledDeliveryTime);
        }

        @Override
        public void acknowledge(Transaction tx) throws Exception {
            this.ref.acknowledge(tx);
        }

        @Override
        public void acknowledge(Transaction tx, ServerConsumer consumer) throws Exception {
            this.ref.acknowledge(tx, consumer);
        }

        @Override
        public void acknowledge(Transaction tx, AckReason reason, ServerConsumer consumer) throws Exception {
            this.ref.acknowledge(tx, reason, consumer);
        }

        @Override
        public void setPersistedCount(int count) {
            this.ref.setPersistedCount(count);
        }

        @Override
        public int getPersistedCount() {
            return this.ref.getPersistedCount();
        }

        @Override
        public boolean isPaged() {
            return false;
        }

        @Override
        public void acknowledge() throws Exception {
            this.ref.getQueue().acknowledge(this);
        }

        @Override
        public int getMessageMemoryEstimate() {
            return this.ref.getMessage().getMemoryEstimate();
        }

        @Override
        public void emptyConsumerID() {
            this.hasConsumerID = false;
        }

        @Override
        public void setConsumerId(long consumerID) {
            this.hasConsumerID = true;
            this.consumerID = consumerID;
        }

        @Override
        public boolean hasConsumerId() {
            return this.hasConsumerID;
        }

        @Override
        public long getConsumerId() {
            if (!this.hasConsumerID) {
                throw new IllegalStateException("consumerID isn't specified: please check hasConsumerId first");
            }
            return this.consumerID;
        }

        @Override
        public long getPersistentSize() throws ActiveMQException {
            return this.ref.getPersistentSize();
        }

        public String toString() {
            return "HolderReference" + "@" + Integer.toHexString(System.identityHashCode(this)) + "[ref=" + this.ref + "]";
        }
    }
}

