/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import jakarta.ws.rs.core.Application;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public class ResteasyDeploymentData {
    private boolean scanAll;
    private boolean scanResources;
    private boolean scanProviders;
    private boolean dispatcherCreated;
    private final Set<String> scannedResourceClasses = new LinkedHashSet<String>();
    private final Set<String> scannedProviderClasses = new LinkedHashSet<String>();
    private List<Class<? extends Application>> scannedApplicationClasses = new ArrayList<Class<? extends Application>>();
    private boolean bootClasses;
    private boolean unwrappedExceptionsParameterSet;
    private final Set<String> scannedJndiComponentResources = new LinkedHashSet<String>();

    public void merge(List<ResteasyDeploymentData> deploymentData) throws DeploymentUnitProcessingException {
        for (ResteasyDeploymentData data : deploymentData) {
            this.scannedApplicationClasses.addAll(data.getScannedApplicationClasses());
            if (this.scanResources) {
                this.scannedResourceClasses.addAll(data.getScannedResourceClasses());
                this.scannedJndiComponentResources.addAll(data.getScannedJndiComponentResources());
            }
            if (!this.scanProviders) continue;
            this.scannedProviderClasses.addAll(data.getScannedProviderClasses());
        }
    }

    public Set<String> getScannedJndiComponentResources() {
        return this.scannedJndiComponentResources;
    }

    public boolean isDispatcherCreated() {
        return this.dispatcherCreated;
    }

    public void setDispatcherCreated(boolean dispatcherCreated) {
        this.dispatcherCreated = dispatcherCreated;
    }

    public List<Class<? extends Application>> getScannedApplicationClasses() {
        return this.scannedApplicationClasses;
    }

    public boolean hasBootClasses() {
        return this.bootClasses;
    }

    public void setBootClasses(boolean bootClasses) {
        this.bootClasses = bootClasses;
    }

    public boolean shouldScan() {
        return this.scanAll || this.scanResources || this.scanProviders;
    }

    public boolean isScanAll() {
        return this.scanAll;
    }

    public void setScanAll(boolean scanAll) {
        if (scanAll) {
            this.scanResources = true;
            this.scanProviders = true;
        }
        this.scanAll = scanAll;
    }

    public boolean isScanResources() {
        return this.scanResources;
    }

    public void setScanResources(boolean scanResources) {
        this.scanResources = scanResources;
    }

    public boolean isScanProviders() {
        return this.scanProviders;
    }

    public void setScanProviders(boolean scanProviders) {
        this.scanProviders = scanProviders;
    }

    public Set<String> getScannedResourceClasses() {
        return this.scannedResourceClasses;
    }

    public Set<String> getScannedProviderClasses() {
        return this.scannedProviderClasses;
    }

    public boolean isUnwrappedExceptionsParameterSet() {
        return this.unwrappedExceptionsParameterSet;
    }

    public void setUnwrappedExceptionsParameterSet(boolean unwrappedExceptionsParameterSet) {
        this.unwrappedExceptionsParameterSet = unwrappedExceptionsParameterSet;
    }
}

