/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.parser.Argument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Option;
import org.apache.cxf.tools.common.toolspec.parser.OptionGroup;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Form
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Form.class);
    private final Element element;
    private final List<Argument> arguments;
    private final List<OptionGroup> optionGroups;
    private final List<Option> options = new ArrayList<Option>();

    public Form(Element el) {
        this.element = el;
        this.optionGroups = DOMUtils.findAllElementsByTagNameNS((Element)this.element, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"optionGroup").stream().map(elem -> new OptionGroup((Element)elem)).collect(Collectors.toList());
        this.arguments = DOMUtils.findAllElementsByTagNameNS((Element)this.element, (String)"http://cxf.apache.org/Xutil/ToolSpecification", (String)"argument").stream().map(elem -> new Argument((Element)elem)).collect(Collectors.toList());
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"option".equals(node.getNodeName())) continue;
            this.options.add(new Option((Element)node));
        }
    }

    @Override
    public boolean accept(TokenInputStream args, Element result, ErrorVisitor errors) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for form of usage: " + this + ", tokens are " + args);
        }
        int oldpos = args.getPosition();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Position is: " + oldpos);
        }
        boolean hasInfo = this.hasInfoOption(args);
        args.setPosition(oldpos);
        while (args.available() > 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Args is available");
            }
            boolean accepted = false;
            for (OptionGroup optionGroup : this.optionGroups) {
                if (!optionGroup.accept(args, result, errors)) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                for (Option option : this.options) {
                    if (!option.accept(args, result, errors)) continue;
                    accepted = true;
                    break;
                }
            }
            if (accepted) continue;
            break;
        }
        for (OptionGroup optionGroup : this.optionGroups) {
            if (optionGroup.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        for (Option option : this.options) {
            if (option.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        for (Argument argument : this.arguments) {
            argument.accept(args, result, errors);
            if (argument.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        if (args.available() > 0) {
            String next = args.peek();
            if (next.startsWith("-")) {
                errors.add(new ErrorVisitor.UnexpectedOption(next));
            } else {
                errors.add(new ErrorVisitor.UnexpectedArgument(next));
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this + " form is returning false as there are more args available that haven't been consumed");
            }
            args.setPosition(oldpos);
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Form " + this + " is returning true");
        }
        return true;
    }

    public boolean hasInfoOption(TokenInputStream args) {
        int pos = args.getPosition();
        args.setPosition(0);
        while (args.available() > 0) {
            String optionValue = args.read();
            if (!"-?".equals(optionValue) && !"-help".equals(optionValue) && !"-h".equals(optionValue) && !"-v".equals(optionValue)) continue;
            return true;
        }
        args.setPosition(pos);
        return false;
    }

    @Override
    public boolean isSatisfied(ErrorVisitor errors) {
        return true;
    }

    public String getName() {
        if (this.element.hasAttribute("value")) {
            return this.element.getAttribute("value");
        }
        return "default";
    }

    public String toString() {
        return this.getName();
    }
}

