/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TCP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Heartbeat-based failure detection protocol")
public abstract class FailureDetection
extends Protocol {
    @Property(description="Timeout after which a node P is suspected if neither a heartbeat nor data were received from P")
    protected long timeout = 40000L;
    @Property(description="Interval at which a HEARTBEAT is sent to the cluster")
    protected long interval = 8000L;
    @ManagedAttribute(description="Number of heartbeats sent")
    protected int num_heartbeats_sent;
    @ManagedAttribute(description="Number of heartbeats received")
    protected int num_heartbeats_received;
    @ManagedAttribute(description="Number of suspected events received")
    protected int num_suspect_events;
    @ManagedAttribute(description="Shows whether there are currently any suspected members")
    protected volatile boolean has_suspected_mbrs;
    protected Address local_addr;
    protected final List<Address> members = new ArrayList<Address>();
    protected final Set<Address> suspected_mbrs = new HashSet<Address>();
    protected final BoundedList<Tuple<Address, Long>> suspect_history = new BoundedList(20);
    protected final Lock lock = new ReentrantLock();
    protected TimeScheduler timer;
    protected final Predicate<Message> HAS_HEADER = msg -> msg != null && msg.getHeader(this.id) != null;
    protected Future<?> heartbeat_sender;
    protected Future<?> timeout_checker;
    protected final AtomicBoolean mcast_sent = new AtomicBoolean(false);

    protected abstract Map<Address, ?> getTimestamps();

    protected abstract long getTimeoutCheckInterval();

    protected abstract String getTimeoutCheckerInfo();

    protected abstract void update(Address var1, boolean var2, boolean var3);

    protected abstract <T> boolean needsToBeSuspected(Address var1, T var2);

    public long getTimeout() {
        return this.timeout;
    }

    public <T extends FailureDetection> T setTimeout(long t) {
        this.timeout = t;
        return (T)this;
    }

    public long getInterval() {
        return this.interval;
    }

    public <T extends FailureDetection> T setInterval(long i) {
        this.interval = i;
        return (T)this;
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    protected void retainKeys(List<Address> mbrs) {
        this.getTimestamps().keySet().retainAll(mbrs);
    }

    protected Runnable createTimeoutChecker() {
        return new TimeoutChecker();
    }

    @ManagedAttribute(description="This member's address")
    public String getLocalAddress() {
        return String.format("%s", this.local_addr);
    }

    @ManagedAttribute(description="The members of the cluster")
    public String getMembers() {
        return Util.printListWithDelimiter(this.members, ",");
    }

    @ManagedAttribute(description="Currently suspected members")
    public synchronized String getSuspectedMembers() {
        return this.suspected_mbrs.toString();
    }

    @ManagedAttribute(description="Are heartbeat tasks running")
    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.isTimeoutCheckerRunning() && this.isHeartbeatSenderRunning();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ManagedAttribute(description="Is the timeout checker task running")
    public boolean isTimeoutCheckerRunning() {
        return this.timeout_checker != null && !this.timeout_checker.isDone();
    }

    @ManagedAttribute(description="Is the heartbeat sender task running")
    public boolean isHeartbeatSenderRunning() {
        return this.heartbeat_sender != null && !this.heartbeat_sender.isDone();
    }

    @ManagedOperation(description="Resumes checking for crashed members")
    public void startFailureDetection() {
        this.startTimeoutChecker();
    }

    @ManagedOperation(description="Stops checking for crashed members")
    public void stopFailureDetection() {
        this.stopTimeoutChecker();
    }

    @ManagedOperation(description="Prints suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Tuple tuple : this.suspect_history) {
            sb.append(new Date((Long)tuple.getVal2())).append(": ").append(tuple.getVal1()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer not set");
        }
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public synchronized void stop() {
        this.stopHeartbeatSender();
        this.stopTimeoutChecker();
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 51: {
                Address mbr = (Address)evt.getArg();
                this.unsuspect(mbr);
                this.update(mbr, false, false);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (msg.getDest() == null) {
            this.mcast_sent.compareAndSet(false, true);
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        Address sender = msg.getSrc();
        Object hdr = msg.getHeader(this.id);
        if (hdr != null) {
            this.update(sender, true, false);
            ++this.num_heartbeats_received;
            this.unsuspect(sender);
            return null;
        }
        this.update(sender, false, false);
        if (this.has_suspected_mbrs) {
            this.unsuspect(sender);
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        int matched_msgs = batch.replaceIf(this.HAS_HEADER, null, true);
        this.update(batch.sender(), matched_msgs > 0, false);
        if (matched_msgs > 0) {
            this.num_heartbeats_received += matched_msgs;
        }
        if (this.has_suspected_mbrs) {
            this.unsuspect(batch.sender());
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        List<Address> mbrs = v.getMembers();
        FailureDetection failureDetection = this;
        synchronized (failureDetection) {
            this.members.clear();
            this.members.addAll(mbrs);
            if (this.suspected_mbrs.retainAll(mbrs)) {
                this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
            }
            this.retainKeys(mbrs);
        }
        mbrs.forEach(m -> this.update((Address)m, false, true));
        if (mbrs.size() > 1) {
            this.startHeartbeatSender();
            this.startTimeoutChecker();
        } else {
            this.stopHeartbeatSender();
            this.stopTimeoutChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(List<Address> suspects) {
        ArrayList<Address> eligible_mbrs;
        if (suspects == null || suspects.isEmpty()) {
            return;
        }
        this.num_suspect_events += suspects.size();
        FailureDetection failureDetection = this;
        synchronized (failureDetection) {
            for (Address suspect : suspects) {
                this.suspect_history.add(new Tuple<Address, Long>(suspect, System.currentTimeMillis()));
                this.suspected_mbrs.add(suspect);
            }
            eligible_mbrs = new ArrayList<Address>(this.members);
            eligible_mbrs.removeAll(this.suspected_mbrs);
            this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
        }
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(eligible_mbrs.get(0))) {
            this.log.debug("%s: suspecting %s", this.local_addr, suspects);
            this.up_prot.up(new Event(9, suspects));
            this.down_prot.down(new Event(9, suspects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsuspect(Address mbr) {
        boolean do_unsuspect;
        if (mbr == null) {
            return false;
        }
        FailureDetection failureDetection = this;
        synchronized (failureDetection) {
            boolean bl = do_unsuspect = !this.suspected_mbrs.isEmpty() && this.suspected_mbrs.remove(mbr);
            if (do_unsuspect) {
                this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
                this.log.debug("%s: unsuspecting %s", this.local_addr, mbr);
            }
        }
        if (do_unsuspect) {
            this.up_prot.up(new Event(51, mbr));
            this.down_prot.down(new Event(51, mbr));
        }
        return do_unsuspect;
    }

    protected void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (!this.isHeartbeatSenderRunning()) {
                this.heartbeat_sender = this.timer.scheduleWithFixedDelay(new HeartbeatSender(this), 0L, this.interval, TimeUnit.MILLISECONDS, this.getTransport() instanceof TCP);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender != null) {
                this.heartbeat_sender.cancel(true);
                this.heartbeat_sender = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (!this.isTimeoutCheckerRunning()) {
                this.timeout_checker = this.timer.scheduleWithFixedDelay(this.createTimeoutChecker(), this.getTimeoutCheckInterval(), this.getTimeoutCheckInterval(), TimeUnit.MILLISECONDS, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker != null) {
                this.timeout_checker.cancel(true);
                this.timeout_checker = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    class TimeoutChecker
    implements Runnable {
        TimeoutChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutChecker timeoutChecker = this;
            synchronized (timeoutChecker) {
                FailureDetection.this.retainKeys(FailureDetection.this.members);
            }
            LinkedList<Address> suspects = new LinkedList<Address>();
            Iterator<Map.Entry<Address, ?>> it = FailureDetection.this.getTimestamps().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Address, ?> entry = it.next();
                Address key = entry.getKey();
                Object val = entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                if (!FailureDetection.this.needsToBeSuspected(key, val)) continue;
                suspects.add(key);
            }
            if (!suspects.isEmpty()) {
                FailureDetection.this.suspect(suspects);
            }
        }

        public String toString() {
            return FailureDetection.this.getTimeoutCheckerInfo();
        }
    }

    class HeartbeatSender
    implements Runnable {
        protected final FailureDetection enclosing;

        HeartbeatSender(FailureDetection enclosing) {
            this.enclosing = enclosing;
        }

        @Override
        public void run() {
            if (!FailureDetection.this.mcast_sent.compareAndSet(true, false)) {
                Message heartbeat = new Message().setFlag(Message.Flag.INTERNAL).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(FailureDetection.this.id, new HeartbeatHeader());
                FailureDetection.this.down_prot.down(heartbeat);
                ++FailureDetection.this.num_heartbeats_sent;
                FailureDetection.this.log.trace("%s: sent heartbeat", FailureDetection.this.local_addr);
            }
        }

        public String toString() {
            return String.format("%s: %s", this.enclosing.getClass().getSimpleName(), this.getClass().getSimpleName());
        }
    }

    public static class HeartbeatHeader
    extends Header {
        @Override
        public short getMagicId() {
            return 62;
        }

        @Override
        public Supplier<? extends Header> create() {
            return HeartbeatHeader::new;
        }

        @Override
        public String toString() {
            return "heartbeat";
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) {
        }

        @Override
        public void readFrom(DataInput in) {
        }
    }
}

