/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BackendsInfo {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Optional<String>, BackendInfo> backendsByNames = new LinkedHashMap<Optional<String>, BackendInfo>();

    public Collection<BackendInfo> values() {
        return this.backendsByNames.values();
    }

    public void collect(Optional<String> name, TenancyMode tenancyMode) {
        this.backendsByNames.merge(name, new BackendInfo(name, tenancyMode), (info1, info2) -> {
            if (((BackendInfo)info1).tenancyMode == ((BackendInfo)info2).tenancyMode) {
                return info1;
            }
            if (name.isPresent()) {
                throw log.differentMultiTenancyNamedBackend((String)name.get());
            }
            throw log.differentMultiTenancyDefaultBackend();
        });
    }

    public static final class BackendInfo {
        private final Optional<String> name;
        private final TenancyMode tenancyMode;

        public BackendInfo(Optional<String> name, TenancyMode tenancyMode) {
            this.name = name;
            this.tenancyMode = tenancyMode;
        }

        public Optional<String> name() {
            return this.name;
        }

        public TenancyMode tenancyStrategy() {
            return this.tenancyMode;
        }
    }
}

