/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

public final class ListProjectionAccumulator<F, V>
implements ProjectionAccumulator<F, V, List<F>, List<V>> {
    private static final ProjectionAccumulator.Provider PROVIDER = new ProjectionAccumulator.Provider(){
        private final ListProjectionAccumulator instance = new ListProjectionAccumulator();

        public ProjectionAccumulator get() {
            return this.instance;
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }
    };

    public static <V> ProjectionAccumulator.Provider<V, List<V>> provider() {
        return PROVIDER;
    }

    private ListProjectionAccumulator() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<F> createInitial() {
        return new ArrayList();
    }

    @Override
    public List<F> accumulate(List<F> accumulated, F value) {
        accumulated.add(value);
        return accumulated;
    }

    @Override
    public List<V> finish(List<F> accumulated, ProjectionConverter<? super F, ? extends V> converter, FromDocumentValueConvertContext context) {
        ListIterator<F> iterator = accumulated.listIterator();
        while (iterator.hasNext()) {
            F fieldValue = iterator.next();
            V convertedValue = converter.fromDocumentValue(fieldValue, context);
            iterator.set(convertedValue);
        }
        return accumulated;
    }
}

