/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReaderBuilder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class PeriodicMetricReader
implements MetricReader {
    private static final Logger logger = Logger.getLogger(PeriodicMetricReader.class.getName());
    private final MetricProducer producer;
    private final MetricExporter exporter;
    private final ScheduledExecutorService scheduler;
    private final Scheduled scheduled;
    private final Object lock = new Object();
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;

    public static MetricReaderFactory newMetricReaderFactory(MetricExporter exporter) {
        return PeriodicMetricReader.builder(exporter).newMetricReaderFactory();
    }

    public static PeriodicMetricReaderBuilder builder(MetricExporter exporter) {
        return new PeriodicMetricReaderBuilder(exporter);
    }

    PeriodicMetricReader(MetricProducer producer, MetricExporter exporter, ScheduledExecutorService scheduler) {
        this.producer = producer;
        this.exporter = exporter;
        this.scheduler = scheduler;
        this.scheduled = new Scheduled();
    }

    @Override
    @Nullable
    public AggregationTemporality getPreferredTemporality() {
        return this.exporter.getPreferredTemporality();
    }

    @Override
    public CompletableResultCode flush() {
        return this.scheduled.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            CompletableResultCode flushResult = this.scheduled.doRun();
            flushResult.join(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            CompletableResultCode shutdownResult = this.scheduled.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(long intervalNanos) {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledFuture != null) {
                return;
            }
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this.scheduled, intervalNanos, intervalNanos, TimeUnit.NANOSECONDS);
        }
    }

    private final class Scheduled
    implements Runnable {
        private final AtomicBoolean exportAvailable = new AtomicBoolean(true);

        private Scheduled() {
        }

        @Override
        public void run() {
            this.doRun();
        }

        CompletableResultCode doRun() {
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.exportAvailable.compareAndSet(true, false)) {
                try {
                    CompletableResultCode result = PeriodicMetricReader.this.exporter.export(PeriodicMetricReader.this.producer.collectAllMetrics());
                    result.whenComplete(() -> {
                        if (!result.isSuccess()) {
                            logger.log(Level.FINE, "Exporter failed");
                        }
                        flushResult.succeed();
                        this.exportAvailable.set(true);
                    });
                }
                catch (Throwable t) {
                    this.exportAvailable.set(true);
                    logger.log(Level.WARNING, "Exporter threw an Exception", t);
                    flushResult.fail();
                }
            } else {
                logger.log(Level.FINE, "Exporter busy. Dropping metrics.");
                flushResult.fail();
            }
            return flushResult;
        }

        CompletableResultCode shutdown() {
            return PeriodicMetricReader.this.exporter.shutdown();
        }
    }
}

