/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;

final class WebHostService
implements Service<WebHost>,
WebHost {
    private final Consumer<WebHost> webHostConsumer;
    private final Supplier<Server> server;
    private final Supplier<Host> host;
    private final Supplier<RequestController> requestController;
    private volatile ControlPoint controlPoint;

    WebHostService(Consumer<WebHost> webHostConsumer, Supplier<Server> server, Supplier<Host> host, Supplier<RequestController> requestController) {
        this.webHostConsumer = webHostConsumer;
        this.server = server;
        this.host = host;
        this.requestController = requestController;
    }

    public WebDeploymentController addWebDeployment(WebDeploymentBuilder webDeploymentBuilder) {
        DeploymentInfo d = new DeploymentInfo();
        d.setDeploymentName(webDeploymentBuilder.getContextRoot());
        d.setContextPath(webDeploymentBuilder.getContextRoot());
        d.setClassLoader(webDeploymentBuilder.getClassLoader());
        d.setResourceManager((ResourceManager)new PathResourceManager(webDeploymentBuilder.getDocumentRoot().toPath().toAbsolutePath(), 0x100000L));
        d.setIgnoreFlush(false);
        for (ServletBuilder servlet : webDeploymentBuilder.getServlets()) {
            ServletInfo s = servlet.getServlet() == null ? new ServletInfo(servlet.getServletName(), servlet.getServletClass()) : new ServletInfo(servlet.getServletName(), servlet.getServletClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servlet.getServlet()));
            if (servlet.isForceInit()) {
                s.setLoadOnStartup(Integer.valueOf(1));
            }
            s.addMappings((Collection)servlet.getUrlMappings());
            for (Map.Entry param : servlet.getInitParams().entrySet()) {
                s.addInitParam((String)param.getKey(), (String)param.getValue());
            }
            d.addServlet(s);
        }
        if (this.controlPoint != null) {
            d.addOuterHandlerChainWrapper(GlobalRequestControllerHandler.wrapper(this.controlPoint, webDeploymentBuilder.getAllowRequestPredicates()));
        }
        return new WebDeploymentControllerImpl(d);
    }

    public void start(StartContext context) {
        RequestController rq;
        RequestController requestController = rq = this.requestController != null ? this.requestController.get() : null;
        if (rq != null) {
            this.controlPoint = rq.getControlPoint("", "org.wildfly.undertow.webhost." + this.server.get().getName() + "." + this.host.get().getName());
        }
        this.webHostConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.webHostConsumer.accept(null);
        if (this.controlPoint != null) {
            this.requestController.get().removeControlPoint(this.controlPoint);
        }
    }

    public WebHost getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private class WebDeploymentControllerImpl
    implements WebDeploymentController {
        private final DeploymentInfo deploymentInfo;
        private volatile DeploymentManager manager;

        private WebDeploymentControllerImpl(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void create() throws Exception {
            ServletContainer container = WebHostService.this.server.get().getServletContainer().getValue().getServletContainer();
            this.manager = container.addDeployment(this.deploymentInfo);
            this.manager.deploy();
        }

        public void start() throws Exception {
            HttpHandler handler = this.manager.start();
            WebHostService.this.host.get().registerDeployment(this.manager.getDeployment(), handler);
        }

        public void stop() throws Exception {
            WebHostService.this.host.get().unregisterDeployment(this.manager.getDeployment());
            this.manager.stop();
        }

        public void destroy() throws Exception {
            this.manager.undeploy();
            ServletContainer container = WebHostService.this.server.get().getServletContainer().getValue().getServletContainer();
            container.removeDeployment(this.deploymentInfo);
        }
    }
}

