/*
 * Decompiled with CFR 0.152.
 */
package org.aesh;

import java.io.IOException;
import java.util.Set;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.ShellImpl;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;

public class AeshRuntimeRunner {
    private Class<? extends Command> command;
    private CommandRuntime runtime;
    private String[] args;
    private boolean interactive = false;

    private AeshRuntimeRunner() {
    }

    public static AeshRuntimeRunner builder() {
        return new AeshRuntimeRunner();
    }

    public AeshRuntimeRunner command(Class<? extends Command> command) {
        this.command = command;
        return this;
    }

    public AeshRuntimeRunner commandRuntime(CommandRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    public AeshRuntimeRunner interactive(boolean interactive) {
        this.interactive = interactive;
        return this;
    }

    public AeshRuntimeRunner args(String[] args) {
        this.args = args;
        return this;
    }

    public void execute() {
        TerminalConnection connection = null;
        if (this.command == null && this.runtime == null) {
            throw new RuntimeException("Command needs to be added");
        }
        try {
            Set<String> commandNames;
            if (this.runtime == null) {
                AeshCommandRuntimeBuilder builder = AeshCommandRuntimeBuilder.builder();
                if (this.interactive) {
                    connection = new TerminalConnection();
                    connection.openNonBlocking();
                    builder.shell(new ShellImpl((Connection)connection));
                }
                this.runtime = builder.commandRegistry(AeshCommandRegistryBuilder.builder().command(this.command).create()).build();
            }
            if ((commandNames = this.runtime.getCommandRegistry().getAllCommandNames()).isEmpty()) {
                throw new RuntimeException("Command needs to be added to the registry.");
            }
            if (commandNames.size() > 1) {
                throw new RuntimeException("Only one command can be added to the registry.");
            }
            String commandName = commandNames.iterator().next();
            StringBuilder sb = new StringBuilder(commandName);
            if (this.args.length > 0) {
                sb.append(" ");
                if (this.args.length == 1) {
                    sb.append(this.args[0]);
                } else {
                    for (String arg : this.args) {
                        if (arg.indexOf(32) >= 0) {
                            sb.append('\"').append(arg).append("\" ");
                            continue;
                        }
                        sb.append(arg).append(' ');
                    }
                }
            }
            try {
                this.runtime.executeCommand(sb.toString());
            }
            catch (CommandNotFoundException e) {
                System.err.println("Command not found: " + sb.toString());
            }
            catch (CommandException | CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
                AeshRuntimeRunner.showHelpIfNeeded(this.runtime, commandName, e);
            }
            catch (IOException | InterruptedException e) {
                System.err.println(e.getMessage());
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (IOException | CommandRegistryException e) {
            throw new RuntimeException("Exception while executing command: " + e.getMessage());
        }
    }

    private static void showHelpIfNeeded(CommandRuntime runtime, String commandName, Exception e) {
        if (e != null) {
            System.err.println(e.getMessage());
        }
        System.err.println(runtime.commandInfo(commandName));
    }
}

