/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.factories.NamedPredicateProvider;
import org.hibernate.search.engine.search.predicate.factories.NamedPredicateProviderContext;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneNamedPredicate
extends AbstractLuceneSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchPredicate instance;

    private LuceneNamedPredicate(Builder builder, LuceneSearchPredicate providedPredicate) {
        super(builder);
        this.instance = providedPredicate;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.instance.checkNestableWithin(expectedParentNestedPath);
        super.checkNestableWithin(expectedParentNestedPath);
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.instance.toQuery(context);
    }

    private static class LuceneNamedPredicateProviderContext
    implements NamedPredicateProviderContext {
        private final SearchPredicateFactory factory;
        private final LuceneSearchIndexCompositeNodeContext field;
        private final String predicateName;
        private final Map<String, Object> params;

        LuceneNamedPredicateProviderContext(SearchPredicateFactory factory, LuceneSearchIndexCompositeNodeContext field, String predicateName, Map<String, Object> params) {
            this.factory = factory;
            this.field = field;
            this.predicateName = predicateName;
            this.params = params;
        }

        public SearchPredicateFactory predicate() {
            return this.factory;
        }

        public Object param(String name) {
            Contracts.assertNotNull((Object)name, (String)"name");
            Object value = this.params.get(name);
            if (value == null) {
                throw log.paramNotDefined(name, this.predicateName, this.field.eventContext());
            }
            return value;
        }

        public Optional<Object> paramOptional(String name) {
            Contracts.assertNotNull((Object)name, (String)"name");
            return Optional.ofNullable(this.params.get(name));
        }
    }

    private static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        private final NamedPredicateProvider provider;
        private final String predicateName;
        private final LuceneSearchIndexCompositeNodeContext field;
        private SearchPredicateFactory factory;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(NamedPredicateProvider provider, String predicateName, LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.provider = provider;
            this.predicateName = predicateName;
            this.field = node;
        }

        public void factory(SearchPredicateFactory factory) {
            this.factory = factory;
        }

        public void param(String name, Object value) {
            this.params.put(name, value);
        }

        public SearchPredicate build() {
            LuceneNamedPredicateProviderContext ctx = new LuceneNamedPredicateProviderContext(this.factory, this.field, this.predicateName, this.params);
            LuceneSearchPredicate providedPredicate = LuceneSearchPredicate.from(this.scope, this.provider.create((NamedPredicateProviderContext)ctx));
            return new LuceneNamedPredicate(this, providedPredicate);
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final NamedPredicateProvider provider;
        private final String predicateName;

        public Factory(NamedPredicateProvider provider, String predicateName) {
            this.provider = provider;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.provider.equals(castedOther.provider)) {
                throw log.differentProviderForQueryElement(this.provider, castedOther.provider);
            }
        }

        public NamedPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            return new Builder(this.provider, this.predicateName, scope, node);
        }
    }
}

