/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.fallback.FallbackContext;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public final class AsyncFallbackFunction<T>
implements FallbackFunction<CompletionStage<T>> {
    private final FallbackFunction<CompletionStage<T>> delegate;
    private final Executor executor;

    public AsyncFallbackFunction(FallbackFunction<CompletionStage<T>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = executor;
    }

    @Override
    public CompletionStage<T> call(FallbackContext<CompletionStage<T>> ctx) throws Exception {
        CompletableFuture result = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                CompletionStages.propagateCompletion(this.delegate.call(ctx), result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

