/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import jakarta.enterprise.context.NormalScope;
import jakarta.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.Annotations;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;

public class DefaultReflectionCache
extends AbstractBootstrapService
implements ReflectionCache {
    private final TypeStore store;
    private final Function<AnnotatedElement, Set<Annotation>> ANNOTATIONS_FUNCTION = input -> ImmutableSet.of(this.internalGetAnnotations((AnnotatedElement)input));
    private final Function<AnnotatedElement, Set<Annotation>> DECLARED_ANNOTATIONS_FUNCTION = input -> ImmutableSet.of(this.internalGetDeclaredAnnotations((AnnotatedElement)input));
    private final ComputingCache<AnnotatedElement, Set<Annotation>> annotations;
    private final ComputingCache<AnnotatedElement, Set<Annotation>> declaredAnnotations;
    private final ComputingCache<Class<?>, Set<Annotation>> backedAnnotatedTypeAnnotations;
    private final ComputingCache<Class<? extends Annotation>, ReflectionCache.AnnotationClass<?>> annotationClasses;

    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    protected Annotation[] internalGetDeclaredAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public DefaultReflectionCache(TypeStore store) {
        this.store = store;
        ComputingCacheBuilder cacheBuilder = ComputingCacheBuilder.newBuilder();
        this.annotations = cacheBuilder.build(this.ANNOTATIONS_FUNCTION);
        this.declaredAnnotations = cacheBuilder.build(this.DECLARED_ANNOTATIONS_FUNCTION);
        this.backedAnnotatedTypeAnnotations = cacheBuilder.build(new BackedAnnotatedTypeAnnotationsFunction());
        this.annotationClasses = cacheBuilder.build(new AnnotationClassFunction());
    }

    public void cleanupAfterBoot() {
        this.annotations.clear();
        this.declaredAnnotations.clear();
        this.backedAnnotatedTypeAnnotations.clear();
        this.annotationClasses.clear();
    }

    @Override
    public Set<Annotation> getAnnotations(AnnotatedElement element) {
        return this.annotations.getValue(element);
    }

    @Override
    public Set<Annotation> getDeclaredAnnotations(AnnotatedElement element) {
        return this.declaredAnnotations.getValue(element);
    }

    @Override
    public Set<Annotation> getBackedAnnotatedTypeAnnotationSet(Class<?> javaClass) {
        return this.backedAnnotatedTypeAnnotations.getValue(javaClass);
    }

    @Override
    public <T extends Annotation> ReflectionCache.AnnotationClass<T> getAnnotationClass(Class<T> clazz) {
        return (ReflectionCache.AnnotationClass)this.annotationClasses.getCastValue(clazz);
    }

    private static class AnnotationClassImpl<T extends Annotation>
    implements ReflectionCache.AnnotationClass<T> {
        private final boolean scope;
        private final Method repeatableAnnotationAccessor;
        private final Set<Annotation> metaAnnotations;

        public AnnotationClassImpl(boolean scope, Method repeatableAnnotationAccessor, Set<Annotation> metaAnnotations) {
            this.scope = scope;
            this.repeatableAnnotationAccessor = repeatableAnnotationAccessor;
            this.metaAnnotations = metaAnnotations;
        }

        @Override
        public Set<Annotation> getMetaAnnotations() {
            return this.metaAnnotations;
        }

        @Override
        public boolean isScope() {
            return this.scope;
        }

        @Override
        public boolean isRepeatableAnnotationContainer() {
            return this.repeatableAnnotationAccessor != null;
        }

        @Override
        public Annotation[] getRepeatableAnnotations(Annotation annotation) {
            if (!this.isRepeatableAnnotationContainer()) {
                throw new IllegalStateException("Not a repeatable annotation container " + annotation);
            }
            try {
                return (Annotation[])this.repeatableAnnotationAccessor.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Error reading repeatable annotations on " + annotation.annotationType(), e);
            }
        }
    }

    private class AnnotationClassFunction
    implements Function<Class<? extends Annotation>, ReflectionCache.AnnotationClass<?>> {
        private AnnotationClassFunction() {
        }

        @Override
        public ReflectionCache.AnnotationClass<?> apply(Class<? extends Annotation> input) {
            boolean scope = input.isAnnotationPresent(NormalScope.class) || input.isAnnotationPresent(Scope.class) || DefaultReflectionCache.this.store.isExtraScope(input);
            Method repeatableAnnotationAccessor = Annotations.getRepeatableAnnotationAccessor(input);
            Set<Annotation> metaAnnotations = ImmutableSet.of(DefaultReflectionCache.this.internalGetAnnotations(input));
            return new AnnotationClassImpl(scope, repeatableAnnotationAccessor, metaAnnotations);
        }
    }

    private class BackedAnnotatedTypeAnnotationsFunction
    implements Function<Class<?>, Set<Annotation>> {
        private BackedAnnotatedTypeAnnotationsFunction() {
        }

        @Override
        public Set<Annotation> apply(Class<?> javaClass) {
            Set<Annotation> annotations = DefaultReflectionCache.this.getAnnotations(javaClass);
            boolean scopeFound = false;
            for (Annotation annotation : annotations) {
                boolean isScope = DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope();
                if (isScope && scopeFound) {
                    return this.applyScopeInheritanceRules(annotations, javaClass);
                }
                if (!isScope) continue;
                scopeFound = true;
            }
            return annotations;
        }

        public Set<Annotation> applyScopeInheritanceRules(Set<Annotation> annotations, Class<?> javaClass) {
            ImmutableSet.Builder<Annotation> result = ImmutableSet.builder();
            for (Annotation annotation : annotations) {
                if (DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope()) continue;
                result.add(annotation);
            }
            result.addAll((Iterable<Annotation>)this.findTopLevelScopeDefinitions(javaClass));
            return result.build();
        }

        public Set<Annotation> findTopLevelScopeDefinitions(Class<?> javaClass) {
            for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                for (Annotation annotation : DefaultReflectionCache.this.getDeclaredAnnotations(clazz)) {
                    if (!DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope()) continue;
                    scopes.add(annotation);
                }
                if (scopes.size() <= 0) continue;
                return scopes;
            }
            throw new IllegalStateException();
        }
    }
}

