/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.SubclassPersistentEntity;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.PersistentClass;

public class UnionSubclassPersistentEntity
extends SubclassPersistentEntity {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public UnionSubclassPersistentEntity(AuditTableData auditTableData, PersistentClass persistentClass) {
        super(auditTableData, persistentClass);
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public void build(JaxbHbmHibernateMapping mapping) {
        mapping.getUnionSubclass().add(this.buildJaxbMapping());
    }

    public JaxbHbmUnionSubclassEntityType buildJaxbMapping() {
        JaxbHbmUnionSubclassEntityType entity = new JaxbHbmUnionSubclassEntityType();
        entity.setExtends(this.getExtends());
        if (this.getPersistentClass() != null) {
            entity.setAbstract(this.getPersistentClass().isAbstract());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditEntityName())) {
            entity.setEntityName(this.getAuditTableData().getAuditEntityName());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditTableName())) {
            entity.setTable(this.getAuditTableData().getAuditTableName());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getSchema())) {
            entity.setSchema(this.getAuditTableData().getSchema());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getCatalog())) {
            entity.setCatalog(this.getAuditTableData().getCatalog());
        }
        for (Attribute attribute : this.attributes) {
            entity.getAttributes().add((Serializable)attribute.build());
        }
        return entity;
    }
}

