/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Iterator;
import java.util.Locale;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.jboss.logging.Logger;

public class CollectionMappedByResolver {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)CollectionMappedByResolver.class.getName());

    public static String resolveMappedBy(Collection collection, PropertyAuditingData propertyAuditingData) {
        PersistentClass referencedClass = CollectionMappedByResolver.getReferenceCollectionClass(collection);
        ResolverContext resolverContext = new ResolverContext(collection, propertyAuditingData);
        return CollectionMappedByResolver.getMappedBy(referencedClass, resolverContext);
    }

    public static String resolveMappedBy(Table collectionTable, PersistentClass referencedClass, PropertyAuditingData propertyAuditingData) {
        return CollectionMappedByResolver.getMappedBy(referencedClass, new ResolverContext(collectionTable, propertyAuditingData));
    }

    public static boolean isMappedByKey(Collection collection, String mappedBy) {
        PersistentClass referencedClass = CollectionMappedByResolver.getReferenceCollectionClass(collection);
        if (referencedClass != null) {
            String keyMappedBy = CollectionMappedByResolver.searchMappedByKey(referencedClass, collection);
            return mappedBy.equals(keyMappedBy);
        }
        return false;
    }

    private static String getMappedBy(PersistentClass referencedClass, ResolverContext resolverContext) {
        String auditMappedBy = resolverContext.propertyAuditingData.getAuditMappedBy();
        if (auditMappedBy != null) {
            return auditMappedBy;
        }
        String mappedBy = CollectionMappedByResolver.searchMappedBy(referencedClass, resolverContext);
        if (mappedBy == null) {
            LOG.debugf("Going to search the mapped by attribute for %s in superclasses of entity: %s", resolverContext.propertyAuditingData.getName(), referencedClass.getClassName());
            PersistentClass tempClass = referencedClass;
            while (mappedBy == null && tempClass.getSuperclass() != null) {
                LOG.debugf("Searching in superclass: %s", tempClass.getSuperclass().getClassName());
                mappedBy = CollectionMappedByResolver.searchMappedBy(tempClass.getSuperclass(), resolverContext);
                tempClass = tempClass.getSuperclass();
            }
        }
        if (mappedBy == null) {
            throw new EnversMappingException(String.format(Locale.ENGLISH, "Unable to read mapped by attribute for %s in %s!", resolverContext.propertyAuditingData.getName(), referencedClass.getClassName()));
        }
        return mappedBy;
    }

    private static String searchMappedBy(PersistentClass persistentClass, ResolverContext resolverContext) {
        if (resolverContext.getCollection() != null) {
            return CollectionMappedByResolver.searchMappedBy(persistentClass, resolverContext.getCollection());
        }
        return CollectionMappedByResolver.searchMappedBy(persistentClass, resolverContext.getTable());
    }

    private static String searchMappedBy(PersistentClass referencedClass, Collection collectionValue) {
        Iterator assocClassProps = referencedClass.getPropertyIterator();
        while (assocClassProps.hasNext()) {
            Iterator collectionKeyColumnIterator;
            Property property = (Property)assocClassProps.next();
            Iterator assocClassColumnIterator = property.getValue().getColumnIterator();
            if (!Tools.iteratorsContentEqual(assocClassColumnIterator, collectionKeyColumnIterator = collectionValue.getKey().getColumnIterator())) continue;
            return property.getName();
        }
        return CollectionMappedByResolver.searchMappedByKey(referencedClass, collectionValue);
    }

    private static String searchMappedBy(PersistentClass referencedClass, Table collectionTable) {
        return CollectionMappedByResolver.searchMappedBy(referencedClass.getPropertyIterator(), collectionTable);
    }

    private static String searchMappedBy(Iterator<Property> properties, Table collectionTable) {
        while (properties.hasNext()) {
            Component component;
            String mappedBy;
            Property property = properties.next();
            if (property.getValue() instanceof Collection) {
                if (((Collection)property.getValue()).getCollectionTable() != collectionTable) continue;
                return property.getName();
            }
            if (!(property.getValue() instanceof Component) || (mappedBy = CollectionMappedByResolver.searchMappedBy((component = (Component)property.getValue()).getPropertyIterator(), collectionTable)) == null) continue;
            return property.getName() + "_" + mappedBy;
        }
        return null;
    }

    private static String searchMappedByKey(PersistentClass referencedClass, Collection collectionValue) {
        for (KeyValue keyValue : referencedClass.getKeyClosure()) {
            if (!(keyValue instanceof Component)) continue;
            Component component = (Component)keyValue;
            Iterator componentPropertyIterator = component.getPropertyIterator();
            while (componentPropertyIterator.hasNext()) {
                Iterator collectionSelectables;
                Property property = (Property)componentPropertyIterator.next();
                Iterator propertySelectables = property.getValue().getColumnIterator();
                if (!Tools.iteratorsContentEqual(propertySelectables, collectionSelectables = collectionValue.getKey().getColumnIterator())) continue;
                return property.getName();
            }
        }
        return null;
    }

    private static PersistentClass getReferenceCollectionClass(Collection collectionValue) {
        PersistentClass referencedClass = null;
        if (collectionValue.getElement() instanceof OneToMany) {
            OneToMany oneToManyValue = (OneToMany)collectionValue.getElement();
            referencedClass = oneToManyValue.getAssociatedClass();
        } else if (collectionValue.getElement() instanceof ManyToOne) {
            ManyToOne manyToOneValue = (ManyToOne)collectionValue.getElement();
            referencedClass = manyToOneValue.getMetadata().getEntityBinding(manyToOneValue.getReferencedEntityName());
        }
        return referencedClass;
    }

    private static class ResolverContext {
        private final Collection collection;
        private final PropertyAuditingData propertyAuditingData;
        private final Table table;

        public ResolverContext(Collection collection, PropertyAuditingData propertyAuditingData) {
            this.collection = collection;
            this.propertyAuditingData = propertyAuditingData;
            this.table = null;
        }

        public ResolverContext(Table table, PropertyAuditingData propertyAuditingData) {
            this.table = table;
            this.propertyAuditingData = propertyAuditingData;
            this.collection = null;
        }

        public Collection getCollection() {
            return this.collection;
        }

        public Table getTable() {
            return this.table;
        }
    }
}

