/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    private SshAgent agent;
    private HostConfigEntry hostConfig;
    private boolean addKeysToAgent;
    private boolean askBeforeAdding;
    private String skProvider;
    private SshAgentKeyConstraint[] constraints;

    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    public void init(ClientSession rawSession, String service) throws Exception {
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session = (JGitClientSession)rawSession;
        this.hostConfig = session.getHostConfigEntry();
        String pubkeyAlgos = this.hostConfig.getProperty("PubkeyAcceptedAlgorithms");
        if (!StringUtils.isEmptyOrNull((String)pubkeyAlgos)) {
            List<String> signatures = session.getSignatureFactoriesNames();
            if (!(signatures = session.modifyAlgorithmList(signatures, session.getAllAvailableSignatureAlgorithms(), pubkeyAlgos, "PubkeyAcceptedAlgorithms")).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PubkeyAcceptedAlgorithms " + signatures);
                }
                this.setSignatureFactoriesNames(signatures);
            } else {
                this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "PubkeyAcceptedAlgorithms", pubkeyAlgos));
            }
        }
        super.init((ClientSession)session, service);
    }

    protected Iterator<PublicKeyIdentity> createPublicKeyIterator(ClientSession session, SignatureFactoriesManager manager) throws Exception {
        this.agent = this.getAgent(session);
        if (this.agent != null) {
            this.parseAddKeys(this.hostConfig);
            if (this.addKeysToAgent) {
                this.skProvider = this.hostConfig.getProperty("SecurityKeyProvider");
            }
        }
        return new KeyIterator(session, manager);
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session, String service) throws Exception {
        PublicKeyIdentity result = this.getNextKey(session, service);
        this.currentAlgorithms.clear();
        return result;
    }

    private PublicKeyIdentity getNextKey(ClientSession session, String service) throws Exception {
        KeyPair key;
        PublicKeyIdentity id = super.resolveAttemptedPublicKeyIdentity(session, service);
        if (this.addKeysToAgent && id != null && !(id instanceof KeyAgentIdentity) && (key = id.getKeyIdentity()) != null && key.getPublic() != null && key.getPrivate() != null) {
            PublicKey pk = key.getPublic();
            String fingerprint = KeyUtils.getFingerPrint((PublicKey)pk);
            String keyType = KeyUtils.getKeyType((KeyPair)key);
            try {
                if (this.agentHasKey(pk)) {
                    return id;
                }
                if (this.askBeforeAdding && session instanceof JGitClientSession) {
                    boolean result;
                    CredentialsProvider provider = ((JGitClientSession)session).getCredentialsProvider();
                    CredentialItem.YesNoType question = new CredentialItem.YesNoType(MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentQuestion, keyType, fingerprint));
                    boolean bl = result = provider != null && provider.supports(new CredentialItem[]{question}) && provider.get(this.getUri(), new CredentialItem[]{question});
                    if (!result || !question.getValue()) {
                        return id;
                    }
                }
                SshAgentKeyConstraint[] rules = this.constraints;
                if (pk instanceof SecurityKeyPublicKey && !StringUtils.isEmptyOrNull((String)this.skProvider)) {
                    rules = Arrays.copyOf(rules, rules.length + 1);
                    rules[rules.length - 1] = new SshAgentKeyConstraint.FidoProviderExtension(this.skProvider);
                }
                this.agent.addIdentity(key, null, rules);
            }
            catch (IOException e) {
                this.log.error(MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentError, keyType, fingerprint), (Throwable)e);
            }
        }
        return id;
    }

    private boolean agentHasKey(PublicKey pk) throws IOException {
        Iterable ids = this.agent.getIdentities();
        if (ids == null) {
            return false;
        }
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            if (!KeyUtils.compareKeys((PublicKey)((PublicKey)((Map.Entry)iter.next()).getKey()), (PublicKey)pk)) continue;
            return true;
        }
        return false;
    }

    private URIish getUri() {
        String uri = "ssh://";
        String userName = this.hostConfig.getUsername();
        if (!StringUtils.isEmptyOrNull((String)userName)) {
            uri = String.valueOf(uri) + userName + '@';
        }
        uri = String.valueOf(uri) + this.hostConfig.getHost();
        int port = this.hostConfig.getPort();
        if (port > 0 && port != 22) {
            uri = String.valueOf(uri) + ":" + port;
        }
        try {
            return new URIish(uri);
        }
        catch (URISyntaxException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            return new URIish();
        }
    }

    private SshAgent getAgent(ClientSession session) throws Exception {
        FactoryManager manager = (FactoryManager)Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory == null) {
            return null;
        }
        return factory.createClient((Session)session, manager);
    }

    private void parseAddKeys(HostConfigEntry config) {
        String value = config.getProperty("AddKeysToAgent");
        if (StringUtils.isEmptyOrNull((String)value)) {
            this.addKeysToAgent = false;
            return;
        }
        String[] values = value.split(",");
        ArrayList<Object> rules = new ArrayList<Object>(2);
        switch (values[0]) {
            case "yes": {
                this.addKeysToAgent = true;
                break;
            }
            case "no": {
                this.addKeysToAgent = false;
                break;
            }
            case "ask": {
                this.addKeysToAgent = true;
                this.askBeforeAdding = true;
                break;
            }
            case "confirm": {
                int seconds;
                this.addKeysToAgent = true;
                rules.add(SshAgentKeyConstraint.CONFIRM);
                if (values.length <= 1 || (seconds = OpenSshConfigFile.timeSpec((String)values[1])) <= 0) break;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
                break;
            }
            default: {
                int seconds = OpenSshConfigFile.timeSpec((String)values[0]);
                if (seconds <= 0) break;
                this.addKeysToAgent = true;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
            }
        }
        this.constraints = rules.toArray(new SshAgentKeyConstraint[0]);
    }

    protected void releaseKeys() throws IOException {
        block6: {
            this.addKeysToAgent = false;
            this.askBeforeAdding = false;
            this.skProvider = null;
            this.constraints = null;
            try {
                if (this.agent == null) break block6;
                try {
                    this.agent.close();
                }
                finally {
                    this.agent = null;
                }
            }
            finally {
                super.releaseKeys();
            }
        }
    }

    private class KeyIterator
    extends UserAuthPublicKeyIterator {
        private Iterable<? extends Map.Entry<PublicKey, String>> agentKeys;
        private Collection<PublicKey> identityFiles;

        public KeyIterator(ClientSession session, SignatureFactoriesManager manager) throws Exception {
            super(session, manager);
        }

        private List<PublicKey> getExplicitKeys(Collection<String> explicitFiles) {
            if (explicitFiles == null) {
                return null;
            }
            return explicitFiles.stream().map(s -> {
                try {
                    Path p = Paths.get(String.valueOf(s) + ".pub", new String[0]);
                    if (Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
                        return ((AuthorizedKeyEntry)AuthorizedKeyEntry.readAuthorizedKeys((Path)p, (OpenOption[])new OpenOption[0]).get(0)).resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
                    }
                }
                catch (IOException | InvalidPathException | GeneralSecurityException e) {
                    JGitPublicKeyAuthentication.this.log.warn(MessageFormat.format(SshdText.get().cannotReadPublicKey, s), (Throwable)e);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        protected Iterable<KeyAgentIdentity> initializeAgentIdentities(ClientSession session) throws IOException {
            if (JGitPublicKeyAuthentication.this.agent == null) {
                return null;
            }
            this.agentKeys = JGitPublicKeyAuthentication.this.agent.getIdentities();
            if (JGitPublicKeyAuthentication.this.hostConfig != null && JGitPublicKeyAuthentication.this.hostConfig.isIdentitiesOnly()) {
                this.identityFiles = this.getExplicitKeys(JGitPublicKeyAuthentication.this.hostConfig.getIdentities());
            }
            return () -> new Iterator<KeyAgentIdentity>(){
                private final Iterator<? extends Map.Entry<PublicKey, String>> iter;
                private Map.Entry<PublicKey, String> next;
                {
                    this.iter = KeyIterator.this.agentKeys.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.next == null && this.iter.hasNext()) {
                        Map.Entry<PublicKey, String> val = this.iter.next();
                        PublicKey pk = val.getKey();
                        if (KeyIterator.this.identityFiles == null || KeyIterator.this.identityFiles.stream().anyMatch(k -> KeyUtils.compareKeys((PublicKey)k, (PublicKey)pk))) {
                            this.next = val;
                            return true;
                        }
                        if (!JGitPublicKeyAuthentication.this.log.isTraceEnabled()) continue;
                        JGitPublicKeyAuthentication.this.log.trace("Ignoring SSH agent {} key not in explicit IdentityFile in SSH config: {}", (Object)KeyUtils.getKeyType((Key)pk), (Object)KeyUtils.getFingerPrint((PublicKey)pk));
                    }
                    return this.next != null;
                }

                @Override
                public KeyAgentIdentity next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    KeyAgentIdentity result = new KeyAgentIdentity(((KeyIterator)KeyIterator.this).JGitPublicKeyAuthentication.this.agent, this.next.getKey(), this.next.getValue());
                    this.next = null;
                    return result;
                }
            };
        }
    }
}

