/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.concurrent;

import com.sun.corba.se.impl.orbutil.concurrent.Sync;
import org.omg.CORBA.INTERNAL;

public class DebugMutex
implements Sync {
    protected boolean inuse_ = false;
    protected Thread holder_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DebugMutex debugMutex = this;
        synchronized (debugMutex) {
            Thread thr = Thread.currentThread();
            if (this.holder_ == thr) {
                throw new INTERNAL("Attempt to acquire Mutex by thread holding the Mutex");
            }
            try {
                while (this.inuse_) {
                    this.wait();
                }
                this.inuse_ = true;
                this.holder_ = Thread.currentThread();
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public synchronized void release() {
        Thread thr = Thread.currentThread();
        if (thr != this.holder_) {
            throw new INTERNAL("Attempt to release Mutex by thread not holding the Mutex");
        }
        this.holder_ = null;
        this.inuse_ = false;
        this.notify();
    }

    @Override
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DebugMutex debugMutex = this;
        synchronized (debugMutex) {
            Thread thr = Thread.currentThread();
            if (!this.inuse_) {
                this.inuse_ = true;
                this.holder_ = thr;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (this.inuse_) continue;
                    this.inuse_ = true;
                    this.holder_ = thr;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }
}

