/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.jpa.hibernate.HibernateArchiveScanner;
import org.jboss.as.jpa.hibernate.HibernateExtendedBeanManager;
import org.jboss.as.jpa.hibernate.HibernateSecondLevelCache;
import org.jboss.as.jpa.hibernate.JpaLogger;
import org.jboss.as.jpa.hibernate.TwoPhaseBootstrapImpl;
import org.jboss.as.jpa.hibernate.management.HibernateManagementAdaptor;
import org.jboss.as.jpa.hibernate.service.WildFlyCustomJtaPlatform;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.event.impl.internal.Notification;
import org.jipijapa.plugin.spi.EntityManagerFactoryBuilder;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.Platform;
import org.jipijapa.plugin.spi.TwoPhaseBootstrapCapable;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor,
TwoPhaseBootstrapCapable {
    public static final String NAMING_STRATEGY_JPA_COMPLIANT_IMPL = "org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl";
    private volatile Platform platform;
    private static final String SHARED_CACHE_MODE = "jakarta.persistence.sharedCache.mode";
    private static final String NONE = SharedCacheMode.NONE.name();
    private static final String UNSPECIFIED = SharedCacheMode.UNSPECIFIED.name();
    private static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";

    public void injectJtaManager(JtaManager jtaManager) {
        WildFlyCustomJtaPlatform.setTransactionSynchronizationRegistry(jtaManager.getSynchronizationRegistry());
    }

    public void injectPlatform(Platform platform) {
        if (this.platform != platform) {
            this.platform = platform;
        }
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.query.jpaql_strict_compliance", "true");
        this.failOnIncompatibleSetting(pu, properties);
        this.putPropertyIfAbsent(pu, properties, "hibernate.auto_quote_keyword", "false");
        this.putPropertyIfAbsent(pu, properties, "hibernate.implicit_naming_strategy", NAMING_STRATEGY_JPA_COMPLIANT_IMPL);
        this.putPropertyIfAbsent(pu, properties, "hibernate.archive.scanner", HibernateArchiveScanner.class);
        properties.put("hibernate.classLoaders", pu.getClassLoader());
        if (!pu.getProperties().containsKey("hibernate.session_factory_name")) {
            this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name_is_jndi", Boolean.FALSE);
        }
        this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name", pu.getScopedPersistenceUnitName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.enable_lazy_load_no_trans", false);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance", true);
    }

    private void failOnIncompatibleSetting(PersistenceUnitMetadata pu, Map properties) {
        if ("false".equals(pu.getProperties().getProperty(USE_NEW_ID_GENERATOR_MAPPINGS))) {
            throw JpaLogger.JPA_LOGGER.failOnIncompatibleSetting();
        }
    }

    public void addProviderDependencies(PersistenceUnitMetadata pu) {
        boolean cacheDisabled;
        Properties properties = pu.getProperties();
        String sharedCacheMode = properties.getProperty(SHARED_CACHE_MODE);
        if (Classification.NONE.equals((Object)this.platform.defaultCacheClassification())) {
            JpaLogger.JPA_LOGGER.tracef("second level cache is not supported in platform, ignoring shared cache mode", new Object[0]);
            pu.setSharedCacheMode(SharedCacheMode.NONE);
        }
        boolean bl = cacheDisabled = this.noneCacheMode(pu) || this.haveHibernateCachePropertyDefined(pu) && !this.hibernateCacheEnabled(pu);
        if (!cacheDisabled) {
            HibernateSecondLevelCache.addSecondLevelCacheDependencies(pu.getProperties(), pu.getScopedPersistenceUnitName());
            JpaLogger.JPA_LOGGER.secondLevelCacheIsEnabled(pu.getScopedPersistenceUnitName());
            if (this.unspecifiedCacheMode(pu)) {
                pu.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
            }
        } else {
            JpaLogger.JPA_LOGGER.tracef("second level cache disabled for %s, pu %s property = %s, pu.getSharedCacheMode = %s", new Object[]{pu.getScopedPersistenceUnitName(), SHARED_CACHE_MODE, sharedCacheMode, pu.getSharedCacheMode().toString()});
            pu.setSharedCacheMode(SharedCacheMode.NONE);
        }
    }

    private boolean haveHibernateCachePropertyDefined(PersistenceUnitMetadata pu) {
        return pu.getProperties().getProperty("hibernate.cache.use_second_level_cache") != null || pu.getProperties().getProperty("hibernate.cache.use_query_cache") != null;
    }

    private boolean hibernateCacheEnabled(PersistenceUnitMetadata pu) {
        return Boolean.parseBoolean(pu.getProperties().getProperty("hibernate.cache.use_second_level_cache")) || Boolean.parseBoolean(pu.getProperties().getProperty("hibernate.cache.use_query_cache"));
    }

    private boolean unspecifiedCacheMode(PersistenceUnitMetadata pu) {
        return SharedCacheMode.UNSPECIFIED.equals((Object)pu.getSharedCacheMode()) || UNSPECIFIED.equals(pu.getProperties().getProperty(SHARED_CACHE_MODE));
    }

    private boolean noneCacheMode(PersistenceUnitMetadata pu) {
        return SharedCacheMode.NONE.equals((Object)pu.getSharedCacheMode()) || NONE.equals(pu.getProperties().getProperty(SHARED_CACHE_MODE));
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        Notification.beforeEntityManagerFactoryCreate((Classification)Classification.INFINISPAN, (PersistenceUnitMetadata)pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        Notification.afterEntityManagerFactoryCreate((Classification)Classification.INFINISPAN, (PersistenceUnitMetadata)pu);
    }

    public ManagementAdaptor getManagementAdaptor() {
        return HibernateManagementAdaptor.getInstance();
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        String cacheRegionPrefix = pu.getProperties().getProperty("hibernate.cache.region_prefix");
        return cacheRegionPrefix == null || cacheRegionPrefix.equals(pu.getScopedPersistenceUnitName());
    }

    public void cleanup(PersistenceUnitMetadata pu) {
    }

    public Object beanManagerLifeCycle(BeanManager beanManager) {
        return new HibernateExtendedBeanManager(beanManager);
    }

    public void markPersistenceUnitAvailable(Object wrapperBeanManagerLifeCycle) {
        HibernateExtendedBeanManager hibernateExtendedBeanManager = (HibernateExtendedBeanManager)wrapperBeanManagerLifeCycle;
        hibernateExtendedBeanManager.beanManagerIsAvailableForUse();
    }

    public EntityManagerFactoryBuilder getBootstrap(PersistenceUnitInfo info, Map map) {
        return new TwoPhaseBootstrapImpl(info, map);
    }
}

