/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.concurrent.TimeoutException;

public class RemoveExpiredCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 58;
    private boolean maxIdle;
    private Long lifespan;

    public RemoveExpiredCommand() {
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    public RemoveExpiredCommand(Object key, Object value, Long lifespan, boolean maxIdle, int segment, long flagBitSet, CommandInvocationId commandInvocationId) {
        super(key, value, segment, flagBitSet, commandInvocationId);
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveExpiredCommand(ctx, this);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public byte getCommandId() {
        return 58;
    }

    @Override
    public String toString() {
        return "RemoveExpiredCommand{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", internalMetadata=" + this.getInternalMetadata() + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.key);
        output.writeObject(this.value);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        if (this.lifespan != null) {
            output.writeBoolean(true);
            output.writeLong(this.lifespan);
        } else {
            output.writeBoolean(false);
        }
        output.writeBoolean(this.maxIdle);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.getInternalMetadata());
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.key = input.readObject();
        this.value = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        boolean lifespanProvided = input.readBoolean();
        this.lifespan = lifespanProvided ? Long.valueOf(input.readLong()) : null;
        this.maxIdle = input.readBoolean();
        this.setFlagsBitSet(input.readLong());
        this.setInternalMetadata((PrivateMetadata)input.readObject());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveExpiredCommand that = (RemoveExpiredCommand)o;
        return this.maxIdle == that.maxIdle && Objects.equals(this.lifespan, that.lifespan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lifespan, this.maxIdle);
    }

    public boolean isMaxIdle() {
        return this.maxIdle;
    }

    public Long getLifespan() {
        return this.lifespan;
    }

    @Override
    public boolean logThrowable(Throwable t) {
        Throwable cause = t;
        do {
            if (!(cause instanceof TimeoutException)) continue;
            return !this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
        } while ((cause = cause.getCause()) != null);
        return true;
    }
}

