/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.threads;

import java.util.AbstractQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import org.infinispan.factories.threads.AbstractThreadPoolExecutorFactory;

public class NonBlockingThreadPoolExecutorFactory
extends AbstractThreadPoolExecutorFactory<ExecutorService> {
    public static final int DEFAULT_KEEP_ALIVE_MILLIS = 60000;

    protected NonBlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
        super(maxThreads, coreThreads, queueLength, keepAlive);
    }

    public boolean createsNonBlockingThreads() {
        return true;
    }

    public ExecutorService createExecutor(ThreadFactory threadFactory) {
        SynchronousQueue<Runnable> queue;
        AbstractQueue abstractQueue = queue = this.queueLength == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(this.queueLength);
        if (!(threadFactory instanceof NonBlockingResource)) {
            throw new IllegalStateException("Executor factory configured to be non blocking and received a thread factory that can create blocking threads!");
        }
        return new ThreadPoolExecutor(this.coreThreads, this.maxThreads, this.keepAlive, TimeUnit.MILLISECONDS, queue, threadFactory, NonBlockingRejectedExecutionHandler.getInstance());
    }

    public void validate() {
        if (this.coreThreads < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("core threads", ">= 0");
        }
        if (this.maxThreads <= 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads", "> 0");
        }
        if (this.maxThreads < this.coreThreads) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads and core threads", "max threads >= core threads");
        }
        if (this.keepAlive < 0L) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("keep alive time", ">= 0");
        }
        if (this.queueLength < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("work queue length", ">= 0");
        }
    }

    public String toString() {
        return "BlockingThreadPoolExecutorFactory{maxThreads=" + this.maxThreads + ", coreThreads=" + this.coreThreads + ", queueLength=" + this.queueLength + ", keepAlive=" + this.keepAlive + '}';
    }

    public static NonBlockingThreadPoolExecutorFactory create(int maxThreads, int queueSize) {
        int coreThreads = queueSize == 0 ? 1 : maxThreads;
        return new NonBlockingThreadPoolExecutorFactory(maxThreads, coreThreads, queueSize, 60000L);
    }
}

