/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFilter;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class InfinispanBeanGroupFactory<I, T, C>
implements BeanGroupFactory<I, T, C> {
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> cache;
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> findCache;
    private final Cache<BeanKey<I>, BeanEntry<I>> beanCache;
    private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter;
    private final MarshalledValueFactory<C> factory;
    private final PassivationListener<T> passivationListener;
    private final MutatorFactory<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> mutatorFactory;
    private final ExecutorService executor = new DefaultExecutorService(this.getClass(), (Function)ExecutorServiceFactory.CACHED_THREAD);

    public InfinispanBeanGroupFactory(Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> cache, Cache<BeanKey<I>, BeanEntry<I>> beanCache, Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter, MarshalledValueFactory<C> factory, CacheProperties properties, PassivationConfiguration<T> passivation) {
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : cache;
        this.beanCache = beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_LISTENER_NOTIFICATION});
        this.beanFilter = beanFilter;
        this.factory = factory;
        this.passivationListener = !properties.isPersistent() ? passivation.getPassivationListener() : null;
        this.cache.addListener((Object)this, (CacheEventFilter)BeanGroupFilter.INSTANCE, null);
        this.mutatorFactory = new InfinispanMutatorFactory((Cache)cache, properties);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int getPassiveCount() {
        return this.cache.getCacheConfiguration().persistence().passivation() ? this.count(EnumSet.noneOf(Flag.class)) - this.count(EnumSet.of(Flag.SKIP_CACHE_LOAD)) : 0;
    }

    private int count(Set<Flag> flags) {
        AdvancedCache cache = flags.isEmpty() ? this.beanCache : this.beanCache.getAdvancedCache().withFlags(flags);
        try (CacheStream keys = cache.keySet().stream();){
            int n = (int)keys.filter(InfinispanBeanKey.class::isInstance).count();
            return n;
        }
    }

    @Override
    public BeanGroupKey<I> createKey(I id) {
        return new InfinispanBeanGroupKey<I>(id);
    }

    public BeanGroupEntry<I, T, C> createValue(I id, Void context) {
        InfinispanBeanGroupEntry entry = new InfinispanBeanGroupEntry(this.factory.createMarshalledValue(new ConcurrentHashMap()));
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put(this.createKey(id), entry);
        return entry;
    }

    public BeanGroupEntry<I, T, C> findValue(I id) {
        return (BeanGroupEntry)this.findCache.get(this.createKey(id));
    }

    public BeanGroupEntry<I, T, C> tryValue(I id) {
        return (BeanGroupEntry)this.findCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).get(this.createKey(id));
    }

    public boolean remove(I id) {
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).remove(this.createKey(id));
        return true;
    }

    @Override
    public BeanGroup<I, T> createGroup(I id, BeanGroupEntry<I, T, C> entry) {
        return this.createGroup(id, entry, this.mutatorFactory.createMutator(this.createKey(id), entry));
    }

    private BeanGroup<I, T> createGroup(I id, BeanGroupEntry<I, T, C> entry, Mutator mutator) {
        return new InfinispanBeanGroup<I, T, Object>(id, entry, this.factory.getMarshallingContext(), mutator, this);
    }

    @Override
    public void evict(I id) {
        this.cache.evict(new InfinispanBeanGroupKey<I>(id));
    }

    @CacheEntryPassivated
    public CompletionStage<Void> passivated(final CacheEntryPassivatedEvent<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> event) {
        if (!event.isPre()) {
            return CompletableFutures.completedNull();
        }
        final Object context = this.factory.getMarshallingContext();
        final InfinispanBeanGroupFactory remover = this;
        final BeanGroupEntry entry = (BeanGroupEntry)event.getValue();
        final Cache<BeanKey<I>, BeanEntry<I>> beanCache = this.beanCache;
        final PassivationListener<T> passivationListener = this.passivationListener;
        final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter = this.beanFilter;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try (InfinispanBeanGroup group = new InfinispanBeanGroup(((BeanGroupKey)event.getKey()).getId(), entry, context, Mutator.PASSIVE, remover);){
                    Set beans = group.getBeans();
                    ArrayList notified = new ArrayList(beans.size());
                    try {
                        for (Object beanId : beans) {
                            InfinispanBeanKey beanKey = new InfinispanBeanKey(beanId);
                            BeanEntry beanEntry = (BeanEntry)beanCache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get(beanKey);
                            if (beanEntry == null || !beanFilter.test(new AbstractMap.SimpleImmutableEntry(beanKey, beanEntry))) continue;
                            InfinispanEjbLogger.ROOT_LOGGER.tracef("Passivating bean %s", beanKey);
                            group.prePassivate(beanId, passivationListener);
                            notified.add(beanId);
                            beanCache.evict(beanKey);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        for (Object beanId : notified) {
                            try {
                                group.postActivate(beanId, passivationListener);
                            }
                            catch (Error | RuntimeException t) {
                                InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                            }
                        }
                        throw e;
                    }
                }
            }
        };
        return CompletableFuture.runAsync(task, this.executor);
    }

    @CacheEntryActivated
    public CompletionStage<Void> activated(final CacheEntryActivatedEvent<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> event) {
        if (event.isPre()) {
            return CompletableFutures.completedNull();
        }
        final Object context = this.factory.getMarshallingContext();
        final InfinispanBeanGroupFactory remover = this;
        final BeanGroupEntry entry = (BeanGroupEntry)event.getValue();
        final Cache<BeanKey<I>, BeanEntry<I>> beanCache = this.beanCache;
        final PassivationListener<T> passivationListener = this.passivationListener;
        final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter = this.beanFilter;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try (InfinispanBeanGroup group = new InfinispanBeanGroup(((BeanGroupKey)event.getKey()).getId(), entry, context, Mutator.PASSIVE, remover);){
                    for (Object beanId : group.getBeans()) {
                        InfinispanBeanKey beanKey = new InfinispanBeanKey(beanId);
                        BeanEntry beanEntry = (BeanEntry)beanCache.get(beanKey);
                        if (beanEntry == null || !beanFilter.test(new AbstractMap.SimpleImmutableEntry(beanKey, beanEntry))) continue;
                        InfinispanEjbLogger.ROOT_LOGGER.tracef("Activating bean %s", beanKey);
                        try {
                            group.postActivate(beanId, passivationListener);
                        }
                        catch (Error | RuntimeException e) {
                            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        };
        return CompletableFuture.runAsync(task, this.executor);
    }
}

