/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import java.util.BitSet;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;

final class PojoPathFilterImpl
implements PojoPathFilter {
    private final PojoPathOrdinals ordinals;
    private final BitSet acceptedPaths;

    public PojoPathFilterImpl(PojoPathOrdinals ordinals, BitSet acceptedPaths) {
        this.ordinals = ordinals;
        this.acceptedPaths = acceptedPaths;
    }

    public String toString() {
        return this.ordinals.toPathSet(this.acceptedPaths).toString();
    }

    @Override
    public boolean test(BitSet pathSelection) {
        return this.acceptedPaths.intersects(pathSelection);
    }

    @Override
    public BitSet filter(String path) {
        Integer ordinal = this.ordinals.toOrdinal(path);
        if (ordinal != null && this.acceptedPaths.get(ordinal)) {
            BitSet result = new BitSet(ordinal);
            result.set(ordinal);
            return result;
        }
        return null;
    }

    @Override
    public BitSet filter(String ... paths) {
        BitSet bitSet = null;
        for (String path : paths) {
            Integer ordinal = this.ordinals.toOrdinal(path);
            if (ordinal == null || !this.acceptedPaths.get(ordinal)) continue;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            bitSet.set(ordinal);
        }
        return bitSet;
    }

    @Override
    public BitSet filter(int[] pathOrdinals) {
        BitSet bitSet = null;
        for (int pathOrdinal : pathOrdinals) {
            if (!this.acceptedPaths.get(pathOrdinal)) continue;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            bitSet.set(pathOrdinal);
        }
        return bitSet;
    }
}

