/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.BeanManagementProvider;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagementProvider;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.extension.clustering.ejb.InfinispanBeanManagementResourceDefinition;

public class InfinispanBeanManagementServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<BeanManagementProvider>,
BeanManagerFactoryServiceConfiguratorConfiguration {
    private volatile String name;
    private volatile String containerName;
    private volatile String cacheName;
    private volatile Integer maxActiveBeans;

    public InfinispanBeanManagementServiceConfigurator(PathAddress address) {
        super((Capability)InfinispanBeanManagementResourceDefinition.Capability.BEAN_MANAGEMENT_PROVIDER, address);
        this.name = address.getLastElement().getValue();
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanBeanManagementResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanBeanManagementResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.maxActiveBeans = InfinispanBeanManagementResourceDefinition.Attribute.MAX_ACTIVE_BEANS.resolveModelAttribute((ExpressionResolver)context, model).asIntOrNull();
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer provider = builder.provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(provider, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public BeanManagementProvider get() {
        return new InfinispanBeanManagementProvider(this.name, (BeanManagerFactoryServiceConfiguratorConfiguration)this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Integer getMaxActiveBeans() {
        return this.maxActiveBeans;
    }
}

