/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public abstract class AbstractSequence {
    protected final Identifier id;
    protected SequenceAcknowledgement acknowledgement;
    private final ProtocolVariation protocol;

    protected AbstractSequence(Identifier i, ProtocolVariation p) {
        this.id = i;
        this.protocol = p;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public ProtocolVariation getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.id.getValue();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractSequence) {
            AbstractSequence otherSeq = (AbstractSequence)other;
            return otherSeq.getIdentifier().getValue().equals(this.getIdentifier().getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getIdentifier().getValue().hashCode();
    }

    public static boolean identifierEquals(Identifier id1, Identifier id2) {
        if (null == id1) {
            return null == id2;
        }
        return null != id2 && id1.getValue().equals(id2.getValue());
    }

    public synchronized boolean isAcknowledged(long m) {
        for (SequenceAcknowledgement.AcknowledgementRange r : this.acknowledgement.getAcknowledgementRange()) {
            if (m < r.getLower() || r.getUpper() < m) continue;
            return true;
        }
        return false;
    }
}

