/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Type;
import java.util.Arrays;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaType;

public class ArrayTupleType
implements TupleType<Object[]>,
ReturnableType<Object[]>,
MappingModelExpressible<Object[]> {
    private final ObjectArrayJavaType javaType;
    private final SqmExpressible<?>[] components;

    public ArrayTupleType(SqmExpressible<?>[] components) {
        this.components = components;
        this.javaType = new ObjectArrayJavaType(ArrayTupleType.getTypeDescriptors(components));
    }

    private static JavaType<?>[] getTypeDescriptors(SqmExpressible<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    @Override
    public int componentCount() {
        return this.components.length;
    }

    @Override
    public String getComponentName(int index) {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public List<String> getComponentNames() {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public SqmExpressible<?> get(int index) {
        return this.components[index];
    }

    @Override
    public SqmExpressible<?> get(String componentName) {
        throw new UnsupportedMappingException("Array tuple has no component names");
    }

    @Override
    public JavaType<Object[]> getExpressibleJavaType() {
        return this.javaType;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    public Class<Object[]> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    public String toString() {
        return "ArrayTupleType" + Arrays.toString(this.components);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

