/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;

@MBean(description="Intercepts single messages and passes them up as batches")
public class MAKE_BATCH
extends Protocol {
    @Property(description="handle multicast messages")
    protected boolean multicasts = false;
    @Property(description="handle unicast messages")
    protected boolean unicasts = false;
    @Property(description="Do not add OOB messages to a batch if true")
    protected boolean skip_oob = true;
    @Property(description="Time to sleep (in ms) from the reception of the first message to sending a batch up", type=AttributeType.TIME)
    protected long sleep_time = 100L;
    protected final Map<Address, List<Message>> reg_map_mcast = new HashMap<Address, List<Message>>();
    protected final Map<Address, List<Message>> reg_map_ucast = new HashMap<Address, List<Message>>();
    protected final Map<Address, List<Message>> oob_map_mcast = new HashMap<Address, List<Message>>();
    protected final Map<Address, List<Message>> oob_map_ucast = new HashMap<Address, List<Message>>();
    protected TimeScheduler timer;
    protected AsciiString cluster_name;
    protected Future<?> batcher;

    public MAKE_BATCH multicasts(boolean flag) {
        this.multicasts = flag;
        return this;
    }

    public MAKE_BATCH unicasts(boolean flag) {
        this.unicasts = flag;
        return this;
    }

    public MAKE_BATCH sleepTime(long time) {
        this.sleep_time = time;
        return this;
    }

    public boolean skipOOB() {
        return this.skip_oob;
    }

    public MAKE_BATCH skipOOB(boolean s) {
        this.skip_oob = s;
        return this;
    }

    @Override
    public void start() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        this.startBatcher();
    }

    @Override
    public void stop() {
        super.stop();
        this.stopBatcher();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = new AsciiString((String)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Message msg) {
        if (msg.isFlagSet(Message.Flag.OOB) && this.skip_oob) {
            return this.up_prot.up(msg);
        }
        if (msg.getDest() == null && this.multicasts || msg.getDest() != null && this.unicasts) {
            this.queue(msg);
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (msg.isFlagSet(Message.Flag.OOB) && this.skip_oob) {
                this.up_prot.up(msg);
                it.remove();
                continue;
            }
            if ((msg.dest() != null || !this.multicasts) && (msg.dest() == null || !this.unicasts)) continue;
            this.queue(msg);
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void queue(Message msg) {
        Address dest = msg.getDest();
        Map<Address, List<Message>> map = dest == null ? (msg.isFlagSet(Message.Flag.OOB) ? this.oob_map_mcast : this.reg_map_mcast) : (msg.isFlagSet(Message.Flag.OOB) ? this.oob_map_ucast : this.reg_map_ucast);
        List list = map.computeIfAbsent(msg.src(), k -> new ArrayList());
        list.add(msg);
    }

    public synchronized MAKE_BATCH startBatcher() {
        if (this.timer == null) {
            this.timer = this.getTransport().getTimer();
        }
        if (this.batcher == null || this.batcher.isDone()) {
            this.batcher = this.timer.scheduleWithFixedDelay(new Batcher(), this.sleep_time, this.sleep_time, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    protected synchronized MAKE_BATCH stopBatcher() {
        if (this.batcher != null) {
            this.batcher.cancel(true);
            this.batcher = null;
        }
        return this;
    }

    protected class Batcher
    implements Runnable {
        protected Batcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessageBatch batch2;
            ArrayList<MessageBatch> batches = new ArrayList<MessageBatch>();
            Map<Address, List<Message>> map = MAKE_BATCH.this.oob_map_mcast;
            synchronized (map) {
                for (Map.Entry<Address, List<Message>> entry : MAKE_BATCH.this.oob_map_mcast.entrySet()) {
                    batch2 = new MessageBatch(null, entry.getKey(), MAKE_BATCH.this.cluster_name, true, (Collection<Message>)entry.getValue()).mode(MessageBatch.Mode.OOB);
                    batches.add(batch2);
                }
                MAKE_BATCH.this.oob_map_mcast.clear();
            }
            map = MAKE_BATCH.this.oob_map_ucast;
            synchronized (map) {
                for (Map.Entry<Address, List<Message>> entry : MAKE_BATCH.this.oob_map_ucast.entrySet()) {
                    batch2 = new MessageBatch(MAKE_BATCH.this.local_addr, entry.getKey(), MAKE_BATCH.this.cluster_name, false, (Collection<Message>)entry.getValue()).mode(MessageBatch.Mode.OOB);
                    batches.add(batch2);
                }
                MAKE_BATCH.this.oob_map_ucast.clear();
            }
            map = MAKE_BATCH.this.reg_map_mcast;
            synchronized (map) {
                for (Map.Entry<Address, List<Message>> entry : MAKE_BATCH.this.reg_map_mcast.entrySet()) {
                    batch2 = new MessageBatch(null, entry.getKey(), MAKE_BATCH.this.cluster_name, true, (Collection<Message>)entry.getValue()).mode(MessageBatch.Mode.REG);
                    batches.add(batch2);
                }
                MAKE_BATCH.this.reg_map_mcast.clear();
            }
            map = MAKE_BATCH.this.reg_map_ucast;
            synchronized (map) {
                for (Map.Entry<Address, List<Message>> entry : MAKE_BATCH.this.reg_map_ucast.entrySet()) {
                    batch2 = new MessageBatch(MAKE_BATCH.this.local_addr, entry.getKey(), MAKE_BATCH.this.cluster_name, false, (Collection<Message>)entry.getValue()).mode(MessageBatch.Mode.REG);
                    batches.add(batch2);
                }
                MAKE_BATCH.this.reg_map_ucast.clear();
            }
            batches.stream().filter(batch -> !batch.isEmpty()).forEach(batch -> MAKE_BATCH.this.up_prot.up((MessageBatch)batch));
        }
    }
}

