/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.JsonUtils;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.TagWriterImpl;

public final class ProtobufUtil {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 4096;
    public static final int DEFAULT_ARRAY_BUFFER_SIZE = 512;

    private ProtobufUtil() {
    }

    public static SerializationContext newSerializationContext() {
        return ProtobufUtil.newSerializationContext(Configuration.builder().build());
    }

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources("org/infinispan/protostream/message-wrapping.proto"));
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(WrappedMessage.MARSHALLER);
        return serializationContext;
    }

    public static <A> int computeMessageSize(ImmutableSerializationContext ctx, A t) throws IOException {
        TagWriterImpl out = TagWriterImpl.newInstance(ctx);
        ProtobufUtil.write(ctx, out, t);
        return out.getWrittenBytes();
    }

    public static <A> int computeWrappedMessageSize(ImmutableSerializationContext ctx, A t) throws IOException {
        TagWriterImpl out = TagWriterImpl.newInstance(ctx);
        WrappedMessage.write(ctx, out, t);
        return out.getWrittenBytes();
    }

    private static <A> void write(ImmutableSerializationContext ctx, TagWriterImpl out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        BaseMarshallerDelegate<A> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t);
        marshallerDelegate.marshall(out, null, t);
        out.flush();
    }

    public static void writeTo(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.write(ctx, TagWriterImpl.newInstance(ctx, out), t);
    }

    public static byte[] toByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static ByteBuffer toByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.getByteBuffer();
    }

    private static <A> A readFrom(TagReaderImpl in, Class<A> clazz) throws IOException {
        if (clazz.isEnum()) {
            throw new IllegalArgumentException("The Class argument must not be an Enum");
        }
        BaseMarshallerDelegate<Class<A>> marshallerDelegate = in.getSerializationContext().getMarshallerDelegate(clazz);
        return (A)marshallerDelegate.unmarshall(in, null);
    }

    public static <A> A readFrom(ImmutableSerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(TagReaderImpl.newInstance(ctx, in), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(TagReaderImpl.newInstance(ctx, bytes), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(TagReaderImpl.newInstance(ctx, bytes, offset, length), clazz);
    }

    public static <A> A fromByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(TagReaderImpl.newInstance(ctx, byteBuffer), clazz);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        return (A)WrappedMessage.read(ctx, TagReaderImpl.newInstance(ctx, bytes, offset, length));
    }

    public static <A> A fromWrappedByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer) throws IOException {
        return (A)WrappedMessage.read(ctx, TagReaderImpl.newInstance(ctx, byteBuffer));
    }

    public static <A> A fromWrappedStream(ImmutableSerializationContext ctx, InputStream in) throws IOException {
        return (A)WrappedMessage.read(ctx, TagReaderImpl.newInstance(ctx, in));
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        return ProtobufUtil.toWrappedByteArray(ctx, t, 512);
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        WrappedMessage.write(ctx, TagWriterImpl.newInstanceNoBuffer(ctx, baos), t);
        return baos.toByteArray();
    }

    public static ByteBuffer toWrappedByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        WrappedMessage.write(ctx, TagWriterImpl.newInstanceNoBuffer(ctx, baos), t);
        return baos.getByteBuffer();
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.toWrappedStream(ctx, out, t, 4096);
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t, int bufferSize) throws IOException {
        WrappedMessage.write(ctx, TagWriterImpl.newInstance(ctx, out, bufferSize), t);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.toCanonicalJSON(ctx, bytes, true);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes, boolean prettyPrint) throws IOException {
        return JsonUtils.toCanonicalJSON(ctx, bytes, prettyPrint);
    }

    public static byte[] fromCanonicalJSON(ImmutableSerializationContext ctx, Reader reader) throws IOException {
        return JsonUtils.fromCanonicalJSON(ctx, reader);
    }
}

