/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBContainerInterceptorsViewConfigurator;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.ServerInterceptorsViewConfigurator;
import org.jboss.as.ejb3.remote.RemoteViewInjectionSource;
import org.jboss.as.ejb3.validator.EjbProxy;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

public class EJBViewDescription
extends ViewDescription {
    private final MethodInterfaceType methodIntf;
    private final boolean hasJNDIBindings;
    private final boolean ejb2xView;

    public EJBViewDescription(ComponentDescription componentDescription, String viewClassName, MethodInterfaceType methodIntf, boolean ejb2xView) {
        super(componentDescription, viewClassName, !ejb2xView && methodIntf != MethodInterfaceType.Home && methodIntf != MethodInterfaceType.LocalHome, EjbProxy.class.getName());
        this.methodIntf = methodIntf;
        this.ejb2xView = ejb2xView;
        this.hasJNDIBindings = this.initHasJNDIBindings(methodIntf);
        this.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.putPrivateData(MethodInterfaceType.class, (Object)EJBViewDescription.this.getMethodIntf());
            }
        });
        this.getConfigurators().add(EJBContainerInterceptorsViewConfigurator.INSTANCE);
        this.getConfigurators().add(ServerInterceptorsViewConfigurator.INSTANCE);
    }

    public MethodInterfaceType getMethodIntf() {
        return this.methodIntf;
    }

    public ViewConfiguration createViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ProxyFactory<?> proxyFactory) {
        return new EJBViewConfiguration(viewClass, componentConfiguration, this.getServiceName(), proxyFactory, this.getMethodIntf());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EJBViewDescription that = (EJBViewDescription)((Object)o);
        if (this.hasJNDIBindings != that.hasJNDIBindings) {
            return false;
        }
        if (this.methodIntf != that.methodIntf) {
            return false;
        }
        if (!this.getViewClassName().equals(that.getViewClassName())) {
            return false;
        }
        if (this.getComponentDescription() != that.getComponentDescription()) {
            return false;
        }
        return super.equals(o);
    }

    protected InjectionSource createInjectionSource(ServiceName serviceName, Value<ClassLoader> viewClassLoader, boolean appclient) {
        if (this.methodIntf != MethodInterfaceType.Remote && this.methodIntf != MethodInterfaceType.Home) {
            return super.createInjectionSource(serviceName, viewClassLoader, appclient);
        }
        EJBComponentDescription componentDescription = this.getComponentDescription();
        EEModuleDescription desc = componentDescription.getModuleDescription();
        String earApplicationName = desc.getEarApplicationName();
        return new RemoteViewInjectionSource(serviceName, earApplicationName, desc.getModuleName(), desc.getDistinctName(), componentDescription.getComponentName(), this.getViewClassName(), componentDescription.isStateful(), viewClassLoader, appclient);
    }

    public EJBComponentDescription getComponentDescription() {
        return (EJBComponentDescription)super.getComponentDescription();
    }

    public ServiceName getServiceName() {
        return super.getServiceName().append(new String[]{this.methodIntf.toString()});
    }

    public int hashCode() {
        int result = this.methodIntf.hashCode();
        result = 31 * result + (this.hasJNDIBindings ? 1 : 0);
        result = 31 * result + this.getViewClassName().hashCode();
        result = 31 * result + this.getComponentDescription().getComponentName().hashCode();
        return result;
    }

    public boolean hasJNDIBindings() {
        return this.hasJNDIBindings;
    }

    private boolean initHasJNDIBindings(MethodInterfaceType methodIntf) {
        if (methodIntf == MethodInterfaceType.MessageEndpoint) {
            return false;
        }
        if (methodIntf == MethodInterfaceType.ServiceEndpoint) {
            return false;
        }
        return methodIntf != MethodInterfaceType.Timer;
    }

    public boolean isEjb2xView() {
        return this.ejb2xView;
    }

    public boolean requiresSuperclassInProxy() {
        return !this.isEjb2xView() && this.methodIntf != MethodInterfaceType.LocalHome && this.methodIntf != MethodInterfaceType.Home;
    }
}

