/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OpenWireToAMQPTest
extends ActiveMQTestBase {
    public static final String OWHOST = "localhost";
    public static final int OWPORT = 61616;
    protected static final String urlString = "tcp://localhost:61616?wireFormat.cacheEnabled=true";
    private ActiveMQServer server;
    protected ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    protected ActiveMQXAConnectionFactory xaFactory = new ActiveMQXAConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    private JmsConnectionFactory qpidfactory;
    protected String queueName = "amqTestQueue1";
    private SimpleString coreQueue;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.getAddressesSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setDeadLetterAddress(new SimpleString("ActiveMQ.DLQ")));
        serverConfig.setSecurityEnabled(false);
        this.server.start();
        this.coreQueue = new SimpleString(this.queueName);
        this.server.createQueue(new QueueConfiguration(this.coreQueue).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        this.qpidfactory = new JmsConnectionFactory("amqp://localhost:61616");
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testObjectMessage() throws Exception {
        Queue queue;
        Session session;
        try (Connection connection = null;){
            connection = this.factory.createConnection();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            ArrayList<String> list = new ArrayList<String>();
            list.add("aString");
            ObjectMessage objectMessage = session.createObjectMessage(list);
            producer.send((Message)objectMessage);
            connection.close();
        }
        try {
            connection = this.qpidfactory.createConnection();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            ObjectMessage receive = (ObjectMessage)consumer.receive(5000L);
            OpenWireToAMQPTest.assertNotNull((Object)receive);
            ArrayList list = (ArrayList)receive.getObject();
            OpenWireToAMQPTest.assertEquals(list.get(0), (Object)"aString");
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            OpenWireToAMQPTest.fail((String)("Failed to receive message via AMQP: " + e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

