/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.tests.integration.management.CoreMessagingProxy;
import org.apache.activemq.artemis.tests.integration.management.QueueControlTest;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QueueControlUsingCoreTest
extends QueueControlTest {
    public QueueControlUsingCoreTest(boolean durable) {
        super(durable);
    }

    @Override
    protected QueueControl createManagementControl(SimpleString address, final SimpleString queue) throws Exception {
        return new QueueControl(){
            private final CoreMessagingProxy proxy;
            {
                this.proxy = new CoreMessagingProxy(QueueControlUsingCoreTest.this.addServerLocator(QueueControlUsingCoreTest.this.createInVMNonHALocator()), "queue." + queue);
            }

            public void flushExecutor() {
                try {
                    this.proxy.invokeOperation("flushExecutor", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public int getPreparedTransactionMessageCount() {
                try {
                    return (Integer)this.proxy.invokeOperation(Integer.class, "getPreparedTransactionMessageCount", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public void resetAllGroups() {
                try {
                    this.proxy.invokeOperation("resetAllGroups", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public void resetGroup(String groupID) {
                try {
                    this.proxy.invokeOperation("resetGroup", groupID);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public int getGroupCount() {
                try {
                    return (Integer)this.proxy.invokeOperation(Integer.TYPE, "getGroupCount", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public String listGroupsAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listGroupsAsJSON", new Object[0]);
            }

            public long getRingSize() {
                try {
                    return (Long)this.proxy.invokeOperation(Integer.TYPE, "getRingSize", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            public boolean isGroupRebalance() {
                return (Boolean)this.proxy.retrieveAttributeValue("groupRebalance");
            }

            public boolean isGroupRebalancePauseDispatch() {
                return (Boolean)this.proxy.retrieveAttributeValue("groupRebalancePauseDispatch");
            }

            public int getGroupBuckets() {
                return (Integer)this.proxy.retrieveAttributeValue("groupBuckets", Integer.class);
            }

            public String getGroupFirstKey() {
                return (String)this.proxy.retrieveAttributeValue("groupFirstKey");
            }

            public boolean changeMessagePriority(long messageID, int newPriority) throws Exception {
                return (Boolean)this.proxy.invokeOperation("changeMessagePriority", messageID, newPriority);
            }

            public int changeMessagesPriority(String filter, int newPriority) throws Exception {
                return (Integer)this.proxy.invokeOperation("changeMessagesPriority", filter, newPriority);
            }

            public long countMessages(String filter) throws Exception {
                return (Long)this.proxy.invokeOperation(Long.class, "countMessages", filter);
            }

            public long countMessages() throws Exception {
                return (Long)this.proxy.invokeOperation(Long.class, "countMessages", new Object[0]);
            }

            public String countMessages(String filter, String groupByFilter) throws Exception {
                return (String)this.proxy.invokeOperation(String.class, "countMessages", filter, groupByFilter);
            }

            public long countDeliveringMessages(String filter) throws Exception {
                return (Long)this.proxy.invokeOperation(Long.class, "countDeliveringMessages", filter);
            }

            public String countDeliveringMessages(String filter, String groupByFilter) throws Exception {
                return (String)this.proxy.invokeOperation(String.class, "countDeliveringMessages", filter, groupByFilter);
            }

            public boolean expireMessage(long messageID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("expireMessage", messageID);
            }

            public int expireMessages(String filter) throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "expireMessages", filter);
            }

            public String getAddress() {
                return (String)this.proxy.retrieveAttributeValue("address");
            }

            public String getUser() {
                return (String)this.proxy.retrieveAttributeValue("user");
            }

            public int getConsumerCount() {
                return (Integer)this.proxy.retrieveAttributeValue("consumerCount", Integer.class);
            }

            public String getDeadLetterAddress() {
                return (String)this.proxy.retrieveAttributeValue("deadLetterAddress");
            }

            public int getMaxConsumers() {
                return (Integer)this.proxy.retrieveAttributeValue("maxConsumers");
            }

            public boolean isPurgeOnNoConsumers() {
                return (Boolean)this.proxy.retrieveAttributeValue("purgeOnNoConsumers");
            }

            public boolean isEnabled() {
                return (Boolean)this.proxy.retrieveAttributeValue("isEnabled");
            }

            public void enable() throws Exception {
                this.proxy.invokeOperation("enable", new Object[0]);
            }

            public void disable() throws Exception {
                this.proxy.invokeOperation("disable", new Object[0]);
            }

            public boolean isConfigurationManaged() {
                return (Boolean)this.proxy.retrieveAttributeValue("configurationManaged");
            }

            public boolean isExclusive() {
                return (Boolean)this.proxy.retrieveAttributeValue("exclusive");
            }

            public boolean isLastValue() {
                return (Boolean)this.proxy.retrieveAttributeValue("lastValue");
            }

            public String getLastValueKey() {
                return (String)this.proxy.retrieveAttributeValue("lastValueKey");
            }

            public int getConsumersBeforeDispatch() {
                return (Integer)this.proxy.retrieveAttributeValue("consumersBeforeDispatch");
            }

            public long getDelayBeforeDispatch() {
                return (Long)this.proxy.retrieveAttributeValue("delayBeforeDispatch");
            }

            public int getDeliveringCount() {
                return (Integer)this.proxy.retrieveAttributeValue("deliveringCount", Integer.class);
            }

            public long getDeliveringSize() {
                return (Long)this.proxy.retrieveAttributeValue("deliveringSize", Long.class);
            }

            public int getDurableDeliveringCount() {
                return (Integer)this.proxy.retrieveAttributeValue("durableDeliveringCount", Integer.class);
            }

            public long getDurableDeliveringSize() {
                return (Long)this.proxy.retrieveAttributeValue("durableDeliveringSize", Long.class);
            }

            public String getExpiryAddress() {
                return (String)this.proxy.retrieveAttributeValue("expiryAddress");
            }

            public String getFilter() {
                return (String)this.proxy.retrieveAttributeValue("filter");
            }

            public long getMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("messageCount", Long.class);
            }

            public long getMessagesAdded() {
                return ((Integer)this.proxy.retrieveAttributeValue("messagesAdded", Integer.class)).intValue();
            }

            public long getMessagesAcknowledged() {
                return ((Integer)this.proxy.retrieveAttributeValue("messagesAcknowledged", Integer.class)).intValue();
            }

            public long getAcknowledgeAttempts() {
                return ((Integer)this.proxy.retrieveAttributeValue("acknowledgeAttempts", Integer.class)).intValue();
            }

            public long getMessagesExpired() {
                return (Long)this.proxy.retrieveAttributeValue("messagesExpired", Long.class);
            }

            public long getMessagesKilled() {
                return ((Number)this.proxy.retrieveAttributeValue("messagesKilled")).longValue();
            }

            public void resetMessagesAdded() throws Exception {
                this.proxy.invokeOperation("resetMessagesAdded", new Object[0]);
            }

            public void resetMessagesAcknowledged() throws Exception {
                this.proxy.invokeOperation("resetMessagesAcknowledged", new Object[0]);
            }

            public void resetMessagesExpired() throws Exception {
                this.proxy.invokeOperation("resetMessagesExpired", new Object[0]);
            }

            public void resetMessagesKilled() throws Exception {
                this.proxy.invokeOperation("resetMessagesKilled", new Object[0]);
            }

            public String getName() {
                return (String)this.proxy.retrieveAttributeValue("name");
            }

            public long getID() {
                return (Long)this.proxy.retrieveAttributeValue("ID");
            }

            public long getScheduledCount() {
                return (Long)this.proxy.retrieveAttributeValue("scheduledCount", Long.class);
            }

            public long getScheduledSize() {
                return (Long)this.proxy.retrieveAttributeValue("scheduledSize", Long.class);
            }

            public long getDurableScheduledCount() {
                return (Long)this.proxy.retrieveAttributeValue("durableScheduledCount", Long.class);
            }

            public long getDurableScheduledSize() {
                return (Long)this.proxy.retrieveAttributeValue("durableScheduledSize", Long.class);
            }

            public boolean isDurable() {
                return (Boolean)this.proxy.retrieveAttributeValue("durable");
            }

            public String getRoutingType() {
                return (String)this.proxy.retrieveAttributeValue("routingType");
            }

            public boolean isTemporary() {
                return (Boolean)this.proxy.retrieveAttributeValue("temporary");
            }

            public boolean isRetroactiveResource() {
                return (Boolean)this.proxy.retrieveAttributeValue("retroactiveResource");
            }

            public String listMessageCounter() throws Exception {
                return (String)this.proxy.invokeOperation("listMessageCounter", new Object[0]);
            }

            public String listMessageCounterAsHTML() throws Exception {
                return (String)this.proxy.invokeOperation("listMessageCounterAsHTML", new Object[0]);
            }

            public String listMessageCounterHistory() throws Exception {
                return (String)this.proxy.invokeOperation("listMessageCounterHistory", new Object[0]);
            }

            public String getFirstMessageAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("getFirstMessageAsJSON", new Object[0]);
            }

            public Long getFirstMessageTimestamp() throws Exception {
                return (Long)this.proxy.invokeOperation("getFirstMessageTimestamp", new Object[0]);
            }

            public Long getFirstMessageAge() throws Exception {
                return (Long)this.proxy.invokeOperation(Long.class, "getFirstMessageAge", new Object[0]);
            }

            public String listMessageCounterHistoryAsHTML() throws Exception {
                return (String)this.proxy.invokeOperation("listMessageCounterHistoryAsHTML", new Object[0]);
            }

            public Map<String, Object>[] listMessages(String filter) throws Exception {
                Object[] res = (Object[])this.proxy.invokeOperation("listMessages", filter);
                Map[] results = new Map[res.length];
                for (int i = 0; i < res.length; ++i) {
                    results[i] = (Map)res[i];
                }
                return results;
            }

            public String listMessagesAsJSON(String filter) throws Exception {
                return (String)this.proxy.invokeOperation("listMessagesAsJSON", filter);
            }

            public Map<String, Object>[] listScheduledMessages() throws Exception {
                Object[] res = (Object[])this.proxy.invokeOperation("listScheduledMessages", new Object[0]);
                Map[] results = new Map[res.length];
                for (int i = 0; i < res.length; ++i) {
                    results[i] = (Map)res[i];
                }
                return results;
            }

            public String listScheduledMessagesAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listScheduledMessagesAsJSON", new Object[0]);
            }

            public int moveMessages(String filter, String otherQueueName) throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "moveMessages", filter, otherQueueName);
            }

            public int moveMessages(int flushLimit, String filter, String otherQueueName, boolean rejectDuplicates) throws Exception {
                return (Integer)this.proxy.invokeOperation("moveMessages", flushLimit, filter, otherQueueName, rejectDuplicates);
            }

            public int moveMessages(int flushLimit, String filter, String otherQueueName, boolean rejectDuplicates, int messageCount) throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "moveMessages", flushLimit, filter, otherQueueName, rejectDuplicates, messageCount);
            }

            public int moveMessages(String filter, String otherQueueName, boolean rejectDuplicates) throws Exception {
                return (Integer)this.proxy.invokeOperation("moveMessages", filter, otherQueueName, rejectDuplicates);
            }

            public boolean moveMessage(long messageID, String otherQueueName) throws Exception {
                return (Boolean)this.proxy.invokeOperation("moveMessage", messageID, otherQueueName);
            }

            public boolean moveMessage(long messageID, String otherQueueName, boolean rejectDuplicates) throws Exception {
                return (Boolean)this.proxy.invokeOperation("moveMessage", messageID, otherQueueName, rejectDuplicates);
            }

            public boolean retryMessage(long messageID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("retryMessage", messageID);
            }

            public int retryMessages() throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "retryMessages", new Object[0]);
            }

            public int removeMessages(String filter) throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "removeMessages", filter);
            }

            public int removeMessages(int limit, String filter) throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "removeMessages", limit, filter);
            }

            public int removeAllMessages() throws Exception {
                return (Integer)this.proxy.invokeOperation(Integer.class, "removeAllMessages", new Object[0]);
            }

            public boolean removeMessage(long messageID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("removeMessage", messageID);
            }

            public void resetMessageCounter() throws Exception {
                this.proxy.invokeOperation("resetMessageCounter", new Object[0]);
            }

            public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
                return (Boolean)this.proxy.invokeOperation("sendMessageToDeadLetterAddress", messageID);
            }

            public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
                return (Integer)this.proxy.invokeOperation("sendMessagesToDeadLetterAddress", filterStr);
            }

            public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password) throws Exception {
                return (String)this.proxy.invokeOperation("sendMessage", headers, type, body, durable, user, password);
            }

            public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password, boolean createMessageId) throws Exception {
                return (String)this.proxy.invokeOperation("sendMessage", headers, type, body, durable, user, password, createMessageId);
            }

            public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
                this.proxy.invokeOperation("setDeadLetterAddress", deadLetterAddress);
            }

            public void setExpiryAddress(String expiryAddress) throws Exception {
                this.proxy.invokeOperation("setExpiryAddress", expiryAddress);
            }

            public void pause() throws Exception {
                this.proxy.invokeOperation("pause", new Object[0]);
            }

            public void pause(boolean persist) throws Exception {
                this.proxy.invokeOperation("pause", persist);
            }

            public void resume() throws Exception {
                this.proxy.invokeOperation("resume", new Object[0]);
            }

            public boolean isPaused() throws Exception {
                return (Boolean)this.proxy.invokeOperation("isPaused", new Object[0]);
            }

            public CompositeData[] browse() throws Exception {
                Map map = (Map)this.proxy.invokeOperation("browse", new Object[0]);
                CompositeData[] compositeDatas = (CompositeData[])map.get(CompositeData.class.getName());
                if (compositeDatas == null) {
                    compositeDatas = new CompositeData[]{};
                }
                return compositeDatas;
            }

            public CompositeData[] browse(int page, int pageSize) throws Exception {
                Map map = (Map)this.proxy.invokeOperation("browse", page, pageSize);
                CompositeData[] compositeDatas = (CompositeData[])map.get(CompositeData.class.getName());
                if (compositeDatas == null) {
                    compositeDatas = new CompositeData[]{};
                }
                return compositeDatas;
            }

            public CompositeData[] browse(int page, int pageSize, String filter) throws Exception {
                Map map = (Map)this.proxy.invokeOperation("browse", page, pageSize, filter);
                CompositeData[] compositeDatas = (CompositeData[])map.get(CompositeData.class.getName());
                if (compositeDatas == null) {
                    compositeDatas = new CompositeData[]{};
                }
                return compositeDatas;
            }

            public CompositeData[] browse(String filter) throws Exception {
                Map map = (Map)this.proxy.invokeOperation("browse", filter);
                CompositeData[] compositeDatas = (CompositeData[])map.get(CompositeData.class.getName());
                if (compositeDatas == null) {
                    compositeDatas = new CompositeData[]{};
                }
                return compositeDatas;
            }

            public String listConsumersAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listConsumersAsJSON", new Object[0]);
            }

            public Map<String, Map<String, Object>[]> listDeliveringMessages() throws Exception {
                Map res = (Map)this.proxy.invokeOperation("listDeliveringMessages", new Object[0]);
                HashMap<String, Map<String, Object>[]> response = new HashMap<String, Map<String, Object>[]>();
                for (Object key : res.keySet()) {
                    Object[] value = (Object[])res.get(key);
                    Map[] results = new Map[value.length];
                    for (int i = 0; i < value.length; ++i) {
                        results[i] = (Map)value[i];
                    }
                    response.put((String)key, results);
                }
                return response;
            }

            public String listDeliveringMessagesAsJSON() throws Exception {
                return (String)this.proxy.invokeOperation("listDeliveringMessagesAsJSON", new Object[0]);
            }

            public long getPersistentSize() {
                return (Long)this.proxy.retrieveAttributeValue("persistentSize", Long.class);
            }

            public long getDurableMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("durableMessageCount", Long.class);
            }

            public long getDurablePersistentSize() {
                return (Long)this.proxy.retrieveAttributeValue("durablePersistentSize", Long.class);
            }
        };
    }
}

