/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsTopicRedeliverTest;
import org.junit.Before;
import org.junit.Test;

public class JMSDurableTopicRedeliverTest
extends JmsTopicRedeliverTest {
    @Override
    @Before
    public void setUp() throws Exception {
        this.durable = true;
        super.setUp();
    }

    @Test
    public void testRedeliverNewSession() throws Exception {
        String text = "TEST: " + System.currentTimeMillis();
        TextMessage sendMessage = this.session.createTextMessage(text);
        this.producer.send(this.producerDestination, (Message)sendMessage);
        Message unackMessage = this.consumer.receive(1000L);
        JMSDurableTopicRedeliverTest.assertNotNull((Object)unackMessage);
        String unackId = unackMessage.getJMSMessageID();
        JMSDurableTopicRedeliverTest.assertEquals((Object)((TextMessage)unackMessage).getText(), (Object)text);
        JMSDurableTopicRedeliverTest.assertFalse((boolean)unackMessage.getJMSRedelivered());
        JMSDurableTopicRedeliverTest.assertEquals((long)unackMessage.getIntProperty("JMSXDeliveryCount"), (long)1L);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer(this.getName());
        Message ackMessage = this.consumer.receive(1000L);
        JMSDurableTopicRedeliverTest.assertNotNull((Object)ackMessage);
        ackMessage.acknowledge();
        String ackId = ackMessage.getJMSMessageID();
        JMSDurableTopicRedeliverTest.assertEquals((Object)((TextMessage)ackMessage).getText(), (Object)text);
        JMSDurableTopicRedeliverTest.assertEquals((long)2L, (long)ackMessage.getIntProperty("JMSXDeliveryCount"));
        JMSDurableTopicRedeliverTest.assertEquals((Object)unackId, (Object)ackId);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer(this.getName());
        JMSDurableTopicRedeliverTest.assertNull((Object)this.consumer.receive(1000L));
    }

    protected String getName() {
        return "JMSDurableTopicRedeliverTest";
    }
}

