/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.paging.PageCountSyncServer;
import org.apache.activemq.artemis.tests.integration.paging.SpawnedServerSupport;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PageCountSyncOnNonTXTest
extends SpawnedTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(1);
    public static final String WORD_START = "&*STARTED&*";
    private long timeToRun;
    Process process;

    @Before
    public void checkLoggerStart() throws Exception {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void checkLoggerEnd() throws Exception {
        try {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222214"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222215"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.timeToRun = 5000L + (long)(RandomUtil.randomPositiveInt() % 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendNoTx() throws Exception {
        String QUEUE_NAME = "myQueue";
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.process = PageCountSyncServer.spawnVMWithLogMacher(WORD_START, runnable, this.getTestDir(), this.timeToRun);
        PageCountSyncOnNonTXTest.assertTrue((String)"Server didn't start in 30 seconds", (boolean)latch.await(30L, TimeUnit.SECONDS));
        ServerLocator locator = this.createNettyNonHALocator();
        try {
            locator = this.createNettyNonHALocator().setReconnectAttempts(0).setInitialConnectAttempts(10).setRetryInterval(500L).setBlockOnDurableSend(false);
            ClientSessionFactory factory = locator.createSessionFactory();
            ClientSession session = factory.createSession(true, true);
            session.createQueue(new QueueConfiguration(QUEUE_NAME));
            ClientProducer producer = session.createProducer(QUEUE_NAME);
            ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
            session.start();
            ClientSession sessionTransacted = factory.createSession(false, false);
            ClientProducer producerTransacted = sessionTransacted.createProducer(QUEUE_NAME);
            ClientConsumer consumerTransacted = sessionTransacted.createConsumer(QUEUE_NAME);
            sessionTransacted.start();
            long start = System.currentTimeMillis();
            long nmsgs = 0L;
            try {
                while (true) {
                    int size;
                    if ((size = RandomUtil.randomPositiveInt() % 1024) == 0) {
                        size = 1024;
                    }
                    ClientMessage msg = session.createMessage(true);
                    msg.getBodyBuffer().writeBytes(new byte[size]);
                    producer.send((Message)msg);
                    if (++nmsgs % 100L == 0L) {
                        producerTransacted.send((Message)msg);
                        for (int i = 0; i < 50; ++i) {
                            msg = consumerTransacted.receive(100L);
                            if (msg == null) continue;
                            msg.acknowledge();
                        }
                        sessionTransacted.commit();
                        msg = consumer.receive(100L);
                        if (msg != null) {
                            msg.acknowledge();
                        }
                    }
                    if (System.currentTimeMillis() - start <= this.timeToRun) continue;
                    session.commit();
                }
            }
            catch (Exception expected) {
                expected.printStackTrace();
                locator.close();
            }
        }
        catch (Throwable throwable) {
            locator.close();
            throw throwable;
        }
        PageCountSyncOnNonTXTest.assertEquals((String)"Process didn't end as expected", (long)1L, (long)this.process.waitFor());
        ActiveMQServer server = SpawnedServerSupport.createServer(this.getTestDir());
        try {
            server.start();
            Wait.assertTrue(() -> ((ActiveMQServer)server).isActive());
            locator = this.createNettyNonHALocator();
            try {
                Queue queue = server.locateQueue(new SimpleString(QUEUE_NAME));
                PageCountSyncOnNonTXTest.assertNotNull((Object)queue);
                long msgs = this.getMessageCount(queue);
                ClientSessionFactory factory = locator.createSessionFactory();
                ClientSession session = factory.createSession(false, false);
                ClientConsumer consumer = session.createConsumer(QUEUE_NAME, false);
                session.start();
                int i = 0;
                while ((long)i < msgs) {
                    ClientMessage msg = consumer.receive(5000L);
                    PageCountSyncOnNonTXTest.assertNotNull((Object)msg);
                    ++i;
                }
                PageCountSyncOnNonTXTest.assertNull((Object)consumer.receiveImmediate());
                session.close();
            }
            finally {
                locator.close();
            }
        }
        finally {
            server.stop();
        }
    }
}

