/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReaderFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class PeriodicMetricReaderBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MINUTES = 1L;
    private final MetricExporter metricExporter;
    private long intervalNanos = TimeUnit.MINUTES.toNanos(1L);
    @Nullable
    private ScheduledExecutorService executor;

    PeriodicMetricReaderBuilder(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
    }

    public PeriodicMetricReaderBuilder setInterval(long interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((interval > 0L ? 1 : 0) != 0, (String)"interval must be positive");
        this.intervalNanos = unit.toNanos(interval);
        return this;
    }

    public PeriodicMetricReaderBuilder setInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setInterval(interval.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PeriodicMetricReaderBuilder setExecutor(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public MetricReaderFactory newMetricReaderFactory() {
        ScheduledExecutorService executor = this.executor;
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("PeriodicMetricReader"));
        }
        return new PeriodicMetricReaderFactory(this.metricExporter, this.intervalNanos, executor);
    }
}

