/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.logging;

import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");

    @Message(value="Could not find migration data in cache %s", id=276)
    public CacheException missingMigrationData(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not migrate key %s", id=277)
    public void keyMigrationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring XML attribute %s, please remove from configuration file", id=293)
    public void ignoreXmlAttribute(Object var1);

    @Message(value="Could not migrate data for cache %s, check remote store config in the target cluster. Make sure only one remote store is present and is pointing to the source cluster", id=397)
    public CacheException couldNotMigrateData(String var1);

    @Message(value="Cannot enable HotRod wrapping if a marshaller and/or an entryWrapper have already been set", id=10005)
    public CacheConfigurationException cannotEnableHotRodWrapping();

    @Message(value="The RemoteCacheStore for cache %s should be configured with hotRodWrapping enabled", id=10007)
    public CacheException remoteStoreNoHotRodWrapping(String var1);

    @Message(value="RemoteStore only supports segmentation when using at least protocol version %s or higher", id=10008)
    public CacheConfigurationException segmentationNotSupportedInThisVersion(ProtocolVersion var1);

    @Message(value="A RemoteStore must be shared in a cache that is clustered", id=10009)
    public CacheConfigurationException clusteredRequiresBeingShared();

    @Message(value="Segmentation is not supported for a RemoteStore when the configured segments %d do not match the remote servers amount %s", id=10010)
    public CacheConfigurationException segmentationRequiresEqualSegments(int var1, Integer var2);

    @Message(value="Segmentation is not supported for a RemoteStore when the configured key media type %s does not match the remote servers key media type %s", id=10011)
    public CacheConfigurationException segmentationRequiresEqualMediaTypes(MediaType var1, MediaType var2);

    @Message(value="The RemoteCacheStore cannot be segmented when grouping is enabled", id=10012)
    public CacheConfigurationException segmentationNotSupportedWithGroups();
}

