/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldCapability;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public class WeldCapabilityImpl
implements WeldCapability {
    static final WeldCapability INSTANCE = new WeldCapabilityImpl();

    private WeldCapabilityImpl() {
    }

    public void registerExtensionInstance(Extension extension, DeploymentUnit unit) {
        if (this.isPartOfWeldDeployment(unit)) {
            WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)unit);
            extensions.registerExtensionInstance(extension, unit);
        }
    }

    public Supplier<BeanManager> addBeanManagerService(DeploymentUnit unit, ServiceBuilder<?> serviceBuilder) {
        if (this.isPartOfWeldDeployment(unit)) {
            return serviceBuilder.requires(ServiceNames.beanManagerServiceName((DeploymentUnit)unit));
        }
        return null;
    }

    public ServiceBuilder<?> addBeanManagerService(DeploymentUnit unit, ServiceBuilder<?> serviceBuilder, Injector<BeanManager> targetInjector) {
        if (this.isPartOfWeldDeployment(unit)) {
            return serviceBuilder.addDependency(ServiceNames.beanManagerServiceName((DeploymentUnit)unit), BeanManager.class, targetInjector);
        }
        return serviceBuilder;
    }

    public boolean isPartOfWeldDeployment(DeploymentUnit unit) {
        return WeldDeploymentMarker.isPartOfWeldDeployment(unit);
    }

    public boolean isWeldDeployment(DeploymentUnit unit) {
        return WeldDeploymentMarker.isWeldDeployment(unit);
    }

    public void markAsWeldDeployment(DeploymentUnit unit) {
        WeldDeploymentMarker.mark(unit);
    }

    public void ignorePrecalculatedJandexForModules(DeploymentUnit deploymentUnit, String ... moduleNames) {
        boolean ee9;
        InterceptionType type = InterceptionType.AROUND_CONSTRUCT;
        boolean bl = ee9 = !type.getClass().getName().startsWith("javax.");
        if (ee9) {
            DeploymentUnit root = deploymentUnit;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            for (String module : moduleNames) {
                root.addToAttachmentList(WeldAttachments.INGORE_PRECALCULATED_JANDEX_MODULES, (Object)module);
            }
        }
    }
}

