/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.tuple.NonIdentifierAttribute;

class DirtyHelper {
    DirtyHelper() {
    }

    public static int[] findDirty(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, SharedSessionContractImplementor session) {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            if (!DirtyHelper.isDirty(properties, currentState, previousState, includeColumns, session, i)) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count++] = i;
        }
        return count == 0 ? null : ArrayHelper.trim(results, count);
    }

    private static boolean isDirty(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, SharedSessionContractImplementor session, int i) {
        if (currentState[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return false;
        }
        if (previousState[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return true;
        }
        return properties[i].isDirtyCheckable() && properties[i].getType().isDirty(previousState[i], currentState[i], includeColumns[i], session);
    }

    public static int[] findModified(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean[] includeProperties, SharedSessionContractImplementor session) {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            if (!DirtyHelper.isModified(properties, currentState, previousState, includeColumns, includeProperties, session, i)) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count++] = i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    private static boolean isModified(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean[] includeProperties, SharedSessionContractImplementor session, int i) {
        return currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && includeProperties[i] && properties[i].isDirtyCheckable() && properties[i].getType().isModified(previousState[i], currentState[i], includeColumns[i], session);
    }
}

