/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class FunctionTableGroup
extends AbstractTableGroup {
    private final FunctionTableReference functionTableReference;

    public FunctionTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, FunctionExpression functionExpression, String sourceAlias, List<String> columnNames, boolean lateral, boolean canUseInnerJoins, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, null, sessionFactory);
        this.functionTableReference = new FunctionTableReference(functionExpression, sourceAlias, columnNames, lateral, sessionFactory);
    }

    @Override
    public boolean isLateral() {
        return this.getPrimaryTableReference().isLateral();
    }

    @Override
    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference groupTableReference;
        if (tableExpression == null) {
            return this.getPrimaryTableReference();
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.functionTableReference.applyAffectedTableNames(nameCollector);
    }

    @Override
    public FunctionTableReference getPrimaryTableReference() {
        return this.functionTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

