/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimeJdbcType
implements JdbcType {
    public static final TimeJdbcType INSTANCE = new TimeJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 92;
    }

    @Override
    public String getFriendlyName() {
        return "TIME";
    }

    public String toString() {
        return "TimeTypeDescriptor";
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Time.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIME);
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Time.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Time time = javaType.unwrap(value, Time.class, options);
                if (value instanceof Calendar) {
                    st.setTime(index, time, (Calendar)value);
                } else if (options.getJdbcTimeZone() != null) {
                    st.setTime(index, time, Calendar.getInstance(options.getJdbcTimeZone()));
                } else {
                    st.setTime(index, time);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Time time = javaType.unwrap(value, Time.class, options);
                if (value instanceof Calendar) {
                    st.setTime(name, time, (Calendar)value);
                } else if (options.getJdbcTimeZone() != null) {
                    st.setTime(name, time, Calendar.getInstance(options.getJdbcTimeZone()));
                } else {
                    st.setTime(name, time);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaType.wrap(rs.getTime(paramIndex, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(rs.getTime(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaType.wrap(statement.getTime(index, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(statement.getTime(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaType.wrap(statement.getTime(name, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(statement.getTime(name), options);
            }
        };
    }
}

