/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.spi;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractTypeOrdering<T> {
    protected AbstractTypeOrdering() {
    }

    public Stream<? extends T> ascendingSuperTypes(T subType) {
        LinkedHashSet result = new LinkedHashSet();
        this.collectSuperTypesAscending(result, subType);
        return result.stream();
    }

    public Stream<? extends T> descendingSuperTypes(T subType) {
        LinkedHashSet result = new LinkedHashSet();
        this.collectSuperTypesDescending(result, subType);
        return result.stream();
    }

    protected abstract T superClass(T var1);

    protected abstract Stream<T> declaredInterfaces(T var1);

    private void collectSuperTypesAscending(Set<T> result, T subType) {
        if (subType == null) {
            return;
        }
        if (!result.add(subType)) {
            return;
        }
        this.declaredInterfaces(subType).forEach(interfaze -> this.collectSuperTypesAscending(result, interfaze));
        this.collectSuperTypesAscending(result, this.superClass(subType));
    }

    private void collectSuperTypesDescending(Set<T> result, T subType) {
        if (subType == null) {
            return;
        }
        if (result.contains(subType)) {
            return;
        }
        this.collectSuperTypesDescending(result, this.superClass(subType));
        this.declaredInterfaces(subType).forEach(interfaze -> this.collectSuperTypesDescending(result, interfaze));
        result.add(subType);
    }
}

