/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NettyFailoverTest
extends FailoverTest {
    @Parameterized.Parameter(value=0)
    public NodeManagerType nodeManagerType;
    private List<ScheduledExecutorService> scheduledExecutorServices = new ArrayList<ScheduledExecutorService>();
    private List<ExecutorService> executors = new ArrayList<ExecutorService>();

    @Parameterized.Parameters(name="{0} Node Manager")
    public static Iterable<? extends Object> nodeManagerTypes() {
        return Arrays.asList({NodeManagerType.Jdbc}, {NodeManagerType.InVM});
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        Assume.assumeThat((String)("Replicated backup is supported only by " + (Object)((Object)NodeManagerType.InVM) + " Node Manager"), (Object)((Object)this.nodeManagerType), (Matcher)Is.is((Object)((Object)NodeManagerType.InVM)));
        return super.createReplicatedBackupNodeManager(backupConfig);
    }

    protected Configuration createDefaultInVMConfig() throws Exception {
        Configuration config = super.createDefaultInVMConfig();
        return config;
    }

    @Override
    protected NodeManager createNodeManager() throws Exception {
        switch (this.nodeManagerType) {
            case InVM: {
                return new InVMNodeManager(false);
            }
            case Jdbc: {
                ThreadFactory daemonThreadFactory = t -> {
                    Thread th = new Thread(t);
                    th.setDaemon(true);
                    return th;
                };
                ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);
                this.scheduledExecutorServices.add(scheduledExecutorService);
                ExecutorService executor = Executors.newFixedThreadPool(2, daemonThreadFactory);
                this.executors.add(executor);
                DatabaseStorageConfiguration dbConf = this.createDefaultDatabaseStorageConfiguration();
                OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
                return JdbcNodeManager.with((DatabaseStorageConfiguration)dbConf, (ScheduledExecutorService)scheduledExecutorService, (ExecutorFactory)executorFactory);
            }
        }
        throw new AssertionError((Object)"enum type not supported!");
    }

    @Override
    protected TestableServer createTestableServer(Configuration config) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreSlavePolicyConfiguration;
        NodeManager nodeManager = this.nodeManager;
        if (isBackup && this.nodeManagerType == NodeManagerType.Jdbc) {
            nodeManager = this.createNodeManager();
        }
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    @After
    public void shutDownExecutors() {
        if (!this.scheduledExecutorServices.isEmpty()) {
            ThreadLeakCheckRule.addKownThread((String)"oracle.jdbc.driver.BlockSource.ThreadedCachingBlockSource.BlockReleaser");
            this.executors.forEach(ExecutorService::shutdown);
            this.scheduledExecutorServices.forEach(ExecutorService::shutdown);
            this.executors.clear();
            this.scheduledExecutorServices.clear();
        }
    }

    @Test(timeout=120000L)
    public void testFailoverWithHostAlias() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", "127.0.0.1");
        TransportConfiguration tc = NettyFailoverTest.createTransportConfiguration((boolean)true, (boolean)false, params);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc})).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)sf, true, true, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 10;
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.crash(session);
        this.sendMessages(session, producer, 10);
        this.receiveMessages(consumer, 0, 10, true);
        session.close();
        sf.close();
        Assert.assertEquals((long)0L, (long)sf.numSessions());
        Assert.assertEquals((long)0L, (long)sf.numConnections());
    }

    public static enum NodeManagerType {
        InVM,
        Jdbc;

    }
}

