/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.critical;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.junit.Assert;
import org.junit.Test;

public class ShutdownOnCriticalIOErrorMoveNextTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplyDownAfterError() throws Exception {
        ShutdownOnCriticalIOErrorMoveNextTest.deleteDirectory((File)new File("./target/server"));
        ActiveMQServer server = this.createServer("./target/server");
        try {
            server.start();
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            Connection connection = factory.createConnection();
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer((Destination)session.createQueue("queue"));
            try {
                for (int i = 0; i < 500; ++i) {
                    producer.send((Message)session.createTextMessage("text"));
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            Wait.waitFor(() -> !server.isStarted());
            Assert.assertFalse((boolean)server.isStarted());
        }
        finally {
            server.stop();
        }
    }

    ActiveMQServer createServer(String folder) throws Exception {
        final AtomicBoolean blocked = new AtomicBoolean(false);
        final Configuration conf = this.createConfig(folder);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        conf.setPersistenceEnabled(true);
        ActiveMQServerImpl server = new ActiveMQServerImpl(conf, (ActiveMQSecurityManager)securityManager){

            protected StorageManager createStorageManager() {
                JournalStorageManager storageManager = new JournalStorageManager(conf, this.getCriticalAnalyzer(), this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.ioCriticalErrorListener){

                    protected Journal createMessageJournal(Configuration config, IOCriticalErrorListener criticalErrorListener, int fileSize) {
                        return new JournalImpl(this.ioExecutorFactory, fileSize, config.getJournalMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), config.getJournalFileOpenTimeout(), this.journalFF, "activemq-data", "amq", this.journalFF.getMaxIO(), 0, criticalErrorListener, config.getJournalMaxAtticFiles()){

                            protected void moveNextFile(boolean scheduleReclaim, boolean block) throws Exception {
                                super.moveNextFile(scheduleReclaim, block);
                                if (blocked.get()) {
                                    throw new IllegalStateException("forcibly down");
                                }
                            }
                        };
                    }

                    public void storeMessage(org.apache.activemq.artemis.api.core.Message message) throws Exception {
                        super.storeMessage(message);
                        blocked.set(true);
                    }
                };
                this.getCriticalAnalyzer().add((CriticalComponent)storageManager);
                return storageManager;
            }
        };
        return server;
    }

    Configuration createConfig(String folder) throws Exception {
        Configuration configuration = this.createDefaultConfig(true);
        configuration.setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(ShutdownOnCriticalIOErrorMoveNextTest.getDefaultJournalType()).setJournalDirectory(folder + "/journal").setBindingsDirectory(folder + "/bindings").setPagingDirectory(folder + "/paging").setLargeMessagesDirectory(folder + "/largemessage").setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword("UnitTestsClusterPassword").setJournalDatasync(false);
        configuration.setSecurityEnabled(false);
        configuration.setPersistenceEnabled(true);
        return configuration;
    }
}

