/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.JCAMetadata;
import org.jboss.jca.common.api.metadata.ValidatableMetadata;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.validator.ValidateException;

public class Capacity
implements JCAMetadata,
ValidatableMetadata {
    private static final long serialVersionUID = 1L;
    private Extension incrementer;
    private Extension decrementer;

    public Capacity(Extension incrementer, Extension decrementer) throws ValidateException {
        this.incrementer = incrementer;
        this.decrementer = decrementer;
        this.validate();
    }

    public Extension getIncrementer() {
        return this.incrementer;
    }

    public Extension getDecrementer() {
        return this.decrementer;
    }

    @Override
    public void validate() throws ValidateException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = prime * result + (this.incrementer == null ? 7 : this.incrementer.hashCode());
        result = prime * result + (this.decrementer == null ? 7 : this.decrementer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity)obj;
        if (this.incrementer == null ? other.incrementer != null : !this.incrementer.equals(other.incrementer)) {
            return false;
        }
        return !(this.decrementer == null ? other.decrementer != null : !this.decrementer.equals(other.decrementer));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<capacity>");
        if (this.incrementer != null) {
            sb.append("<").append((Object)Tag.INCREMENTER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.incrementer.getClassName()).append("\"");
            sb.append(">");
            if (this.incrementer.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.incrementer.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)Tag.INCREMENTER).append(">");
        }
        if (this.decrementer != null) {
            sb.append("<").append((Object)Tag.DECREMENTER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.decrementer.getClassName()).append("\"");
            sb.append(">");
            if (this.decrementer.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.decrementer.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)Tag.DECREMENTER).append(">");
        }
        sb.append("</capacity>");
        return sb.toString();
    }

    public static enum Tag {
        UNKNOWN(null),
        INCREMENTER("incrementer"),
        DECREMENTER("decrementer");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

