/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2SqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DB2FormatEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.DB2LimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.LegacyDB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.DB2UniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.CharJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2Dialect
extends Dialect {
    private static final int BIND_PARAMETERS_NUMBER_LIMIT = Short.MAX_VALUE;
    private static final String FOR_READ_ONLY_SQL = " for read only with rs";
    private static final String FOR_SHARE_SQL = " for read only with rs use and keep share locks";
    private static final String FOR_UPDATE_SQL = " for read only with rs use and keep update locks";
    private static final String SKIP_LOCKED_SQL = " skip locked data";
    private static final String FOR_SHARE_SKIP_LOCKED_SQL = " for read only with rs use and keep share locks skip locked data";
    private static final String FOR_UPDATE_SKIP_LOCKED_SQL = " for read only with rs use and keep update locks skip locked data";
    private final LimitHandler limitHandler = this.getDB2Version().isBefore(11, 1) ? LegacyDB2LimitHandler.INSTANCE : DB2LimitHandler.INSTANCE;
    private final UniqueDelegate uniqueDelegate = this.createUniqueDelegate();

    public DB2Dialect() {
        this(DatabaseVersion.make(9, 0));
    }

    public DB2Dialect(DialectResolutionInfo info) {
        super(info);
    }

    public DB2Dialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
    }

    public DatabaseVersion getDB2Version() {
        return this.getVersion();
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 0;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getDB2Version().isBefore(11) ? "smallint" : super.columnType(sqlTypeCode);
            }
            case -6: {
                return "smallint";
            }
            case 2: {
                return this.columnType(3);
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case 2013: {
                return "time";
            }
            case -3: {
                return this.getDB2Version().isBefore(11) ? "varchar($l) for bit data" : super.columnType(sqlTypeCode);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        if (this.getDB2Version().isBefore(11)) {
            ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, "varchar($l) for bit data", this).withTypeCapacity(254L, "char($l) for bit data").build());
        }
    }

    protected UniqueDelegate createUniqueDelegate() {
        return new DB2UniqueDelegate(this);
    }

    @Override
    public int getMaxVarcharLength() {
        return 32672;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return this.getDB2Version().isSameOrAfter(11, 1);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(queryEngine);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.log();
        functionFactory.log10();
        functionFactory.radians();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("substr").setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setArgumentCountBetween(2, 4).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.ANY).setArgumentListSignature("(STRING string, INTEGER start[, INTEGER length[, units]])").register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("substring").setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setArgumentCountBetween(2, 4).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.ANY).setArgumentListSignature("(STRING string{ INTEGER from|,} start[{ INTEGER for|,} length[, units]])").register();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.dateTimeTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.trunc();
        functionFactory.truncate();
        functionFactory.insert();
        functionFactory.overlayCharacterLength_overlay();
        functionFactory.median();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.variance();
        functionFactory.stdevVarianceSamp();
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.yearsMonthsDaysHoursMinutesSecondsBetween();
        functionFactory.dateTrunc();
        functionFactory.bitLength_pattern("length(?1)*8");
        queryEngine.getSqmFunctionRegistry().register("concat", new CastingConcatFunction(this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().register("count", new CountFunction(this, queryEngine.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "||", queryEngine.getTypeConfiguration().getDdlTypeRegistry().getDescriptor(12).getCastTypeName(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING), null, null, null), true));
        queryEngine.getSqmFunctionRegistry().register("format", new DB2FormatEmulation(queryEngine.getTypeConfiguration()));
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("posstr").setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, STRING pattern)").register();
        functionFactory.windowFunctions();
        if (this.getDB2Version().isSameOrAfter(9, 5)) {
            functionFactory.listagg(null);
            if (this.getDB2Version().isSameOrAfter(11, 1)) {
                functionFactory.inverseDistributionOrderedSetAggregates();
                functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
            }
        }
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castFrom = fromTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        boolean castTo = toTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("(seconds_between(");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("trunc(months_between(");
                break;
            }
            default: {
                pattern.append("?1s_between(");
            }
        }
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(",");
        if (castFrom) {
            pattern.append("cast(?2 as timestamp)");
        } else {
            pattern.append("?2");
        }
        pattern.append(")");
        switch (unit) {
            case NATIVE: {
                pattern.append("+(microsecond(?3)-microsecond(?2))/1e6)");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9+(microsecond(?3)-microsecond(?2))*1e3)");
                break;
            }
            case MONTH: {
                pattern.append(")");
                break;
            }
            case QUARTER: {
                pattern.append("/3)");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        boolean castTo;
        StringBuilder pattern = new StringBuilder();
        if (unit.isDateUnit()) {
            castTo = temporalType == TemporalType.TIME;
        } else {
            boolean bl = castTo = temporalType == TemporalType.DATE;
        }
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append("+(");
        switch (unit) {
            case NATIVE: {
                pattern.append("?2) seconds");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?2)/1e9) seconds");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7) days");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3) months");
                break;
            }
            default: {
                pattern.append("?2) ?1s");
            }
        }
        return pattern.toString();
    }

    @Override
    public String getLowercaseFunction() {
        return this.getDB2Version().isBefore(9, 7) ? "lcase" : super.getLowercaseFunction();
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getDB2Version().isBefore(9, 7) ? LegacyDB2SequenceSupport.INSTANCE : DB2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    @Override
    public String getForUpdateString() {
        return FOR_UPDATE_SQL;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getDB2Version().isSameOrAfter(11, 5);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateSkipLockedString();
    }

    @Override
    public String getWriteLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getReadLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_SHARE_SKIP_LOCKED_SQL : FOR_SHARE_SQL;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2Dialect.selectNullString(sqlType);
    }

    static String selectNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 1: 
            case 12: {
                literal = "''";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 92: {
                literal = "'00:00:00'";
                break;
            }
            case 93: 
            case 2014: {
                literal = "'2000-1-1 00:00:00'";
                break;
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + "," + literal + ")";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.getDB2Version().isBefore(11)) {
            jdbcTypeRegistry.addDescriptor(16, SmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(-3, VarbinaryJdbcType.INSTANCE_WITHOUT_LITERALS);
            if (this.getDB2Version().isBefore(9, 7)) {
                jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
            }
        }
        jdbcTypeRegistry.addDescriptor(-15, CharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2011, this.useInputStreamToInsertBlob() ? ClobJdbcType.STREAM_BINDING : ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(-9, VarcharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("BX'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if (-952 == errorCode && "57014".equals(sqlState)) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2IdentityColumnSupport();
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return this.getDB2Version().isSameOrAfter(9, 1);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getDB2Version().isBefore(11)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        if (unit == TemporalUnit.WEEK) {
            return "week_iso(?2)";
        }
        return super.extractPattern(unit);
    }

    @Override
    public int getInExpressionCountLimit() {
        return Short.MAX_VALUE;
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }
}

