/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Constructor;
import java.security.ProtectionDomain;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContextWrapper;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ExceptionHelper;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private static final Constructor<Exception> TRANSFORMER_CONSTRUCTOR;
    private final EnhancementContext enhancementContext;

    public EnhancingClassTransformerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            Enhancer enhancer = Environment.getBytecodeProvider().getEnhancer(new EnhancementContextWrapper(this.enhancementContext, loader));
            return enhancer.enhance(className, classfileBuffer);
        }
        catch (Exception e) {
            Throwable t;
            if (TRANSFORMER_CONSTRUCTOR == null) {
                t = new IllegalClassFormatException("Error performing enhancement of " + className){

                    @Override
                    public synchronized Throwable getCause() {
                        return e;
                    }
                };
            } else {
                try {
                    t = TRANSFORMER_CONSTRUCTOR.newInstance("Error performing enhancement of " + className, e);
                }
                catch (Exception ex) {
                    t = new IllegalClassFormatException("Error performing enhancement of " + className){

                        @Override
                        public synchronized Throwable getCause() {
                            return e;
                        }
                    };
                }
            }
            ExceptionHelper.doThrow(t);
            return null;
        }
    }

    static {
        Constructor<?> constructor = null;
        try {
            Class<?> transformerException = Class.forName("jakarta.persistence.spi.TransformerException");
            constructor = transformerException.getConstructor(String.class, Throwable.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        TRANSFORMER_CONSTRUCTOR = constructor;
    }
}

