/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.access;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.access.BaseNaturalIdLoadAccessImpl;
import org.hibernate.loader.access.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;

public class NaturalIdLoadAccessImpl<T>
extends BaseNaturalIdLoadAccessImpl<T>
implements NaturalIdLoadAccess<T> {
    private final Map<String, Object> naturalIdParameters = new LinkedHashMap<String, Object>();

    public NaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        super(context, entityDescriptor);
    }

    @Override
    public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        return (NaturalIdLoadAccessImpl)super.with(lockOptions);
    }

    @Override
    public NaturalIdLoadAccess<T> using(String attributeName, Object value) {
        this.naturalIdParameters.put(attributeName, value);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> using(Object ... mappings) {
        CollectionHelper.collectMapEntries(this.naturalIdParameters::put, mappings);
        return this;
    }

    @Override
    public NaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
        super.synchronizationEnabled(synchronizationEnabled);
        return this;
    }

    @Override
    public final T getReference() {
        SessionImplementor session = this.getContext().getSession();
        Object normalizedValue = this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters, session);
        return this.doGetReference(normalizedValue);
    }

    @Override
    public final T load() {
        SessionImplementor session = this.getContext().getSession();
        Object normalizedValue = this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters, session);
        return this.doLoad(normalizedValue);
    }

    @Override
    public Optional<T> loadOptional() {
        return Optional.ofNullable(this.load());
    }
}

