/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.OutputableType;
import org.hibernate.sql.exec.internal.JdbcCallFunctionReturnImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class FunctionReturnImpl<T>
implements FunctionReturnImplementor<T> {
    private final ProcedureCallImplementor<T> procedureCall;
    private final int jdbcTypeCode;
    private OutputableType<T> ormType;

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, int jdbcTypeCode) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, OutputableType<T> ormType) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = ormType.getJdbcType().getJdbcTypeCode();
        this.ormType = ormType;
    }

    @Override
    public JdbcCallFunctionReturn toJdbcFunctionReturn(SharedSessionContractImplementor persistenceContext) {
        JdbcCallParameterExtractorImpl parameterExtractor;
        BasicType ormType;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        if (this.getJdbcTypeCode() == 2012) {
            refCursorExtractor = new JdbcCallRefCursorExtractorImpl(null, 1);
            ormType = null;
            parameterExtractor = null;
        } else {
            TypeConfiguration typeConfiguration = persistenceContext.getFactory().getTypeConfiguration();
            JdbcType sqlTypeDescriptor = typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.getJdbcTypeCode());
            BasicJavaType javaTypeMapping = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
            ormType = typeConfiguration.standardBasicTypeForJavaType(javaTypeMapping.getJavaTypeClass());
            parameterExtractor = new JdbcCallParameterExtractorImpl(this.procedureCall.getProcedureName(), null, 1, ormType);
            refCursorExtractor = null;
        }
        return new JdbcCallFunctionReturnImpl(ormType, parameterExtractor, refCursorExtractor);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.ormType;
    }

    public String getName() {
        return null;
    }

    public Integer getPosition() {
        return 1;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    public Class getParameterType() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public void applyAnticipatedType(BindableType type) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.ormType != null) {
                return new FunctionReturnImpl<T>(this.procedureCall, this.ormType);
            }
            return new FunctionReturnImpl<T>(this.procedureCall, this.jdbcTypeCode);
        };
    }
}

