/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.cli.commands.tools.journal.CompactJournal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InfiniteRedeliveryTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(InfiniteRedeliveryTest.class);
    String protocol;
    boolean useCLI;
    TestableServer liveServer;
    TestableServer backupServer;
    Configuration backupConfig;
    Configuration liveConfig;

    @Parameterized.Parameters(name="protocol={0}, useCLI={1}")
    public static Collection getParameters() {
        return Arrays.asList({"CORE", true}, {"AMQP", false}, {"OPENWIRE", false});
    }

    public InfiniteRedeliveryTest(String protocol, boolean useCLI) {
        this.protocol = protocol;
        this.useCLI = useCLI;
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreSlavePolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration liveConnector = TransportConfigurationUtils.getNettyConnector(true, 0);
        TransportConfiguration backupConnector = TransportConfigurationUtils.getNettyConnector(false, 0);
        TransportConfiguration backupAcceptor = TransportConfigurationUtils.getNettyAcceptor(false, 0);
        this.backupConfig = this.createDefaultConfig(0, true);
        this.liveConfig = this.createDefaultConfig(0, true);
        this.configureReplicationPair(backupConnector, backupAcceptor, liveConnector);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.backupServer = this.createTestableServer(this.backupConfig, (NodeManager)new InVMNodeManager(true, this.backupConfig.getJournalLocation()));
        this.liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(TransportConfigurationUtils.getNettyAcceptor(true, 0));
        this.liveServer = this.createTestableServer(this.liveConfig, (NodeManager)new InVMNodeManager(false, this.liveConfig.getJournalLocation()));
    }

    protected void configureReplicationPair(TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration liveConnector) {
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.liveConfig, liveConnector, null);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected void startServer(boolean reschedule) throws Exception {
        this.createReplicatedConfigs();
        Configuration configuration = this.liveServer.getServer().getConfiguration();
        configuration.getAddressesSettings().clear();
        if (reschedule) {
            AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(Integer.MAX_VALUE).setRedeliveryDelay(1L);
            configuration.getAddressesSettings().put("#", settings);
        } else {
            AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(Integer.MAX_VALUE).setRedeliveryDelay(0L);
            configuration.getAddressesSettings().put("#", settings);
        }
        this.liveServer.start();
        this.backupServer.start();
        Wait.waitFor(() -> ((ActiveMQServer)this.liveServer.getServer()).isReplicaSync());
    }

    @Test
    public void testInifinteRedeliveryWithScheduling() throws Exception {
        this.testInifinteRedeliveryWithScheduling(true);
    }

    @Test
    public void testInifinteRedeliveryWithoutScheduling() throws Exception {
        this.testInifinteRedeliveryWithScheduling(false);
    }

    public void testInifinteRedeliveryWithScheduling(boolean reschedule) throws Exception {
        this.startServer(reschedule);
        this.liveServer.getServer().addAddressInfo(new AddressInfo("test").setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.liveServer.getServer().createQueue(new QueueConfiguration("test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setDurable(Boolean.valueOf(true)));
        ConnectionFactory factory = this.protocol.toUpperCase().equals("OPENWIRE") ? CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616?jms.redeliveryPolicy.maximumRedeliveries=100&jms.redeliveryPolicy.redeliveryDelay=0") : CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        Queue queue = session.createQueue("test");
        Assert.assertNotNull((Object)queue);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("hello"));
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 100; ++i) {
            Message message = consumer.receive(10000L);
            Assert.assertNotNull((Object)message);
            session.rollback();
        }
        connection.close();
        if (!this.useCLI) {
            this.liveServer.getServer().getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
            this.backupServer.getServer().getStorageManager().getMessageJournal().scheduleCompactAndBlock(5000);
        }
        this.liveServer.stop();
        this.backupServer.stop();
        if (this.useCLI) {
            CompactJournal.compactJournals((Configuration)this.backupServer.getServer().getConfiguration());
            CompactJournal.compactJournals((Configuration)this.liveServer.getServer().getConfiguration());
        }
        HashMap counts = this.countJournal(this.liveServer.getServer().getConfiguration());
        counts.forEach((k, v) -> logger.debug((Object)(k + "=" + v)));
        counts.forEach((k, v) -> Assert.assertTrue((String)("Record type " + k + " has a lot of records:" + v), (v.intValue() < 20 ? (byte)1 : (byte)0) != 0));
        HashMap backupCounts = this.countJournal(this.backupServer.getServer().getConfiguration());
        Assert.assertTrue((backupCounts.size() > 0 ? (byte)1 : 0) != 0);
        backupCounts.forEach((k, v) -> logger.debug((Object)("On Backup:" + k + "=" + v)));
        backupCounts.forEach((k, v) -> Assert.assertTrue((String)("Backup Record type " + k + " has a lot of records:" + v), (v.intValue() < 10 ? (byte)1 : (byte)0) != 0));
    }
}

